package LCM::Configuration::ValueChangeListeners::Update::XsTenantInstallationListener;

use strict;
use base 'LCM::Configuration::ValueChangeListeners::InstallUpdate::XsTenantInstallationListenerBase';
use SDB::Install::Globals qw($gKeynameXS2);

sub shouldEnableRelevantParameters {
    my ($self, $instconfig) = @_;
    if ($instconfig->isUpdatingComponent($gKeynameXS2)) {
        return 0;
    }
    return $self->SUPER::shouldEnableRelevantParameters($instconfig);
}

sub getRelevantParameterID {
    my ($self, $instconfig) = @_;
    my $isSystemSingletenant = $instconfig->isSystemInCompatibilityMode();
    my $isUpdatingXS2 = $instconfig->isUpdatingComponent($gKeynameXS2);
    if ($isSystemSingletenant && !$isUpdatingXS2) {
        return 'InstallXSInDefaultTenant';
    }
    return $self->SUPER::getRelevantParameterID($instconfig);
}

1;