package LCM::Configuration::Web::OptionTimeout;
use strict;
use base qw ( SDB::Install::Configuration::OptionTimeout );

sub parseArg{
    my ($self, $arg, $ignoreError,$context) = @_;

    my ($argKey, $argValue) = ($arg =~ /(.+):(.+)/);
    if ( ! $argKey || ! $argValue ) {
        return 1;
    }

    my $errStr = "Parsing '$context' failed:";
    if ( ! $self->keyIsValid ($argKey) ) {
        $errStr .= " Unknown argument '$argKey'";
        return $self->handleError ($errStr, $ignoreError);
    }

    if ( defined $argValue && ($argValue !~ /^\d+$/ || $argValue !~ /^[1-9][0-9]*$/) ) {
        $errStr .= "Value of argument '$argKey' has to be a positive integer";
        return $self->handleError ($errStr, $ignoreError);
    }

    $self->{_args}->{$argKey} = $argValue;
    return 1;
}


1;