package LCM::Configuration::Web::UpdateComponentsConfiguration;

use strict;
use base qw (LCM::Configuration::Web::GenericStackUpdateConfiguration);
use LCM::Configuration::GenericStackAny qw($ini_section_xsa);
use LCM::Installer;

sub new{
	my $class = shift;
	my $self = $class->SUPER::new(@_);
	$self->_initializeResidentConfiguration();
	return $self;
}

sub _initializeResidentConfiguration {
	my ($self) = @_;

	for my $paramId ('CertificatesHostmap', 'CheckMnt', 'InstallHostagent', 'UseSimpleUI'){
		if(exists($self->{params}->{$paramId})){
			$self->{params}->{$paramId}->{skip} = 1;
			$self->{params}->{$paramId}->{hidden} = 1;
		}
	}

	$self->{params}->{SelectedComponents}->{valid_values} = [];
	$self->{params}->{ISCMode}->{section} = $ini_section_xsa;
}

sub addListeners {
    my ($self) = @_;
    $self->SUPER::addListeners();
    $self->addParameterListener('SID', sub { return $self->handleVerifySignatureDefaultValue(); });
}

sub getRemoteInstallerExecutable{
    my ($self,$actionProgressive, $remoteTool) = @_;
	return $self->getRemoteExecutable($actionProgressive, $remoteTool);
}

sub InitDefaults {
	my ( $self, $kit ) = @_;
	my $rc = $self->SUPER::InitDefaults($kit);
	$self->removeHdbupdParams();
	return $rc;
}

sub removeHdbupdParams {
	my ($self) = @_;
	for my $key ( keys %{$self->{params}} ) {
		if ( $key =~ /^hdbupd/ ) {
			$self->deleteParamById($key);
		}
	}
}

sub setSID {
	my ($self, $value) = @_;

	return undef if(!$self->SUPER::setSID($value));

	$self->_initParamResumePendingUpdate($value);

	return 1;
}

sub _getCurrentServerVersion {
	my ($self) = @_;
	my $installerVersion = new LCM::Installer()->GetVersion();
	return $installerVersion;
}

sub isResidentUpdate {
	return 1;
}

1;
