package LCM::Configuration::Web::UpdateSystemConfiguration;

use strict;
use LCM::Installer;
use LCM::Component;
use SDB::Install::MsgLst;
use experimental qw (smartmatch);
use LCM::FileUtils qw (MyRealPath);
use LCM::Slpp::Update::MediumAnalyzer;
use SDB::Install::SysVars qw ($path_separator);
use SDB::Install::Globals qw ($gKeynameEngine $gUseDefaultValue);
use parent 'LCM::Configuration::Web::GenericStackUpdateConfiguration';
use LCM::Configuration::ValueChangeListeners::Update::UpdateSystemListener;

# Override
sub InitDefaults {
    my $self = shift();

    return undef if(!$self->SUPER::InitDefaults(@_));

    # This is needed so the WebUI can display the proper default
    # values for parameters that are given in the 'auto_install.cfg'
    for my $paramId (@{$self->getParamIds()}){
        my $cfgValue = $self->getValueFromConfigfile($paramId);
        if (defined($cfgValue) && $self->getType($paramId) !~ /map/) {
            $self->setDefault($paramId, $cfgValue);
        }
    }
    return 1;
}

#Override
sub addListeners {
    my ($self) = @_;
    $self->SUPER::addListeners();
    $self->addParameterListener('SID', LCM::Configuration::ValueChangeListeners::Update::UpdateSystemListener->new());
    $self->addParameterListener('SQLSysPasswd', sub {
        return 1 if(!$self->getValue('UseSimpleUI'));

        for my $paramId (@{$self->getParamIds()}){
            my $configFileValue = $self->getValueFromConfigfile($paramId, 1); # return actual config file value

            next if (!defined($configFileValue));
            next if($self->hasValue($paramId));
            next if($self->isSkipped($paramId));

            my $targetValue = ($configFileValue eq $gUseDefaultValue) ? $self->getDefault($paramId) : $configFileValue;
            if(defined($targetValue) && $self->getType($paramId) !~ /map/){
                 $self->setValue ($paramId, $targetValue);
            }
        }

        my $orgManagerUser = $self->getValue('OrgManagerUser');
        if ($orgManagerUser) {
            $self->{params}->{'OrgManagerPassword'}->{str} = sprintf('XS Advanced Admin User (%s) Password', $orgManagerUser);
        }
        return 1;
    });
}

sub getRemoteInstallerExecutable{
    my ($self) = @_;
    return $self->SUPER::getRemoteInstallerExecutable();
}

sub setSID {
	my ($self, $value) = @_;

	return undef if(!$self->SUPER::setSID($value));

# If called from a DVD the SID value is needed (see incident 1570463539/2015) in order to call _analyzeMedium
# setSID is called right after InitDefaults in case of an SLP execution
	$self->_analyzeMedium();
	$self->_initParamResumePendingUpdate($value);

	return 1;
}

sub _analyzeMedium {
	my ($self) = @_;

	return if ($self->{mediumAnalyzed});

	my $serverPath = MyRealPath( join ($path_separator, (LCM::Installer->new()->getRuntimeDir(), '..', 'server')));
	$self->{scanner}->scan('ComponentDirs', $serverPath);

	my $analyzer = new LCM::Slpp::Update::MediumAnalyzer($self);
	$analyzer->analyze();

	$self->{mediumAnalyzed} = 1;
}

sub _getCurrentServerVersion {
	my ($self) = @_;
	my $serverComponent = $self->getComponentManager()->getComponentByKeyName($gKeynameEngine);
	return $serverComponent->getVersion();
}

1;
