package LCM::Executors::ExecutionExitCodeHandler;

use strict;

sub new {
	my ($class) = @_;

	my $self = {};
	bless $self, $class;

	$self->setHasWarning(0);
	$self->{_exitCodeOnWarning} = undef;

	return $self;
}

sub onWarning {
    my ( $self, $message ) = @_;

   	$self->setHasWarning(1);

	if (!exists $ENV{'HDBLCM_EXIT_CODE_ON_WARNING'}) {
		return 1;
	}

	my $exitCodeOnWarning = $ENV{'HDBLCM_EXIT_CODE_ON_WARNING'};

	if (!defined $exitCodeOnWarning) {
		return 1;
	}

	$self->setExitCodeOnWarning($exitCodeOnWarning);

	return 1;
}

sub hasWarning {
	return $_[0]->{_hasWarning};
}

sub setHasWarning {
	$_[0]->{_hasWarning} = $_[1];
}

sub getExitCodeOnWarning {
	return $_[0]->{_exitCodeOnWarning};
}

sub setExitCodeOnWarning {
	$_[0]->{_exitCodeOnWarning} = $_[1];
}

1;
