package LCM::Executors::Web::FileBrowserExecutor;

use strict;
use LCM::Slpp::ExecutionState qw(STATE_INITIAL);
use base qw (LCM::Executors::BaseExecutor);

sub new {
	my ( $class, $config ) = @_;

	my $self = shift->SUPER::new ({
		requiresInput => 0,
		requiresSummary => 0,
		requiresConfirmation => 0,
		requiresLog => 0,
		requiresHeaderMsg => 0,
	});

	$self->{config} = $config;

	return $self;
}

sub execute {
	my $self = shift;
	return 1;
}

sub getSlppExecutionSteps { 
	require LCM::Slpp::ExecutionStep;
	return [ new LCM::Slpp::ExecutionStep('File Browser', 'file_browser.log', $_[0]) ];
}

sub getWarnings { return []; }

sub getNumberOfExpectedOutputLines { return 1; }

1;
