package LCM::Fcgi::App::ProcessActivityListener;

use strict;
use threads;
use LCM::Slpp::ExecutionState qw(STATE_DIALOG);

sub new {
	my ($class, $slppExecutionHandler, $slppAdapter, $inactivityTimeout) = @_;
	my $self = {
		_inactivityTimeout => $inactivityTimeout,
		_executionHandler => $slppExecutionHandler,
		_customSignalHandler => sub {
			return if($slppExecutionHandler->getState() ne STATE_DIALOG);

			my $configuration = $slppAdapter->getConfiguration();
			$configuration->getMsgLst()->addMessage("Process is inactive for '$inactivityTimeout' seconds. Stopping process...");
			$slppExecutionHandler->abort();
			threads->exit();
		},
	};
	return bless($self, $class);
}

sub notify {
	my ($self) = @_;
	my $executionHandler = $self->{_executionHandler};
	my $inactivityTimeout = $self->{_inactivityTimeout};

# Custom SIGNAL handler is set only for the purpose of automatically stopping the process after X seconds of inactivity while in dialog state
	if($executionHandler->getState() eq STATE_DIALOG) {
		$SIG{ALRM} = $self->{_customSignalHandler};
# Start a new timer if the process is in DIALOG state
		alarm($inactivityTimeout);
	}
}

1;