package LCM::Gui::App::LCMGuiAppInstalled;

use strict;
use base qw ( LCM::Gui::App::LCMGuiApp );

use LCM::Configuration::GenericStackUninstallation;
use LCM::Configuration::UpdateComponentListConfiguration;
use LCM::Configuration::SLD::RegistrationConfiguration;
use LCM::Configuration::InternalNetworkConfiguration;
use LCM::Configuration::Hosts::HostsConfigurationFactory;
use LCM::Configuration::Hosts::RemoveHosts::RemoveHostsConfiguration;
use LCM::Configuration::UnregisterConfiguration;
use LCM::Configuration::AddHostRolesConfiguration;
use LCM::Configuration::RemoveHostRolesConfiguration;
use LCM::Configuration::UpdateSystemBootstrapConfiguration;
use SDB::Install::SysVars qw($isWin);
use LCM::ExecutionWarningsObservable;
use LCM::Executors::ExecutionWarningsHandler;
use LCM::Gui::Dialogs::UpdateHosts::ProgressHandler;
use LCM::ComponentProgressHandler;

sub createActionConfiguration {
	my ( $self, ) = @_;

	require LCM::Configuration::HdbLcmInstalledActionConfiguration;
	$self->{options}->{isGUI} = 1;
	return new LCM::Configuration::HdbLcmInstalledActionConfiguration( $self->{options}, $self->{configfile} );
}

sub createConfiguration{
	my ( $self, $action ) = @_;

	if ( "uninstall" eq $action ) {
		return new LCM::Configuration::GenericStackUninstallation( $self->{options}, $self->{configfile} );
	} elsif ( "update_component_list" eq $action ) {
		return new LCM::Configuration::UpdateComponentListConfiguration( $self->{options}, $self->{configfile} );
	} elsif ( 'configure_sld' eq $action ) {
		return new LCM::Configuration::SLD::RegistrationConfiguration( $self->{options}, $self->{configfile} );
	} elsif ( 'update_components' eq $action ) {
		require  LCM::Configuration::GenericStackConfigurationFactory;
		return LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createUpdateResidentConfiguration($self);
	} elsif ( 'configure_internal_network' eq $action ) {
		return new LCM::Configuration::InternalNetworkConfiguration( $self->{options}, $self->{configfile} );
	} elsif ( !$isWin && (('rename_system' eq $action) || ('register_rename_system' eq $action)) ) {
	    # currently rename scenario is supported only under linux
        return new LCM::Configuration::RenameSystemConfiguration( $self->{options}, $self->{configfile});
	} elsif ('add_hosts' eq $action) {
        return LCM::Configuration::Hosts::HostsConfigurationFactory::NewAddHostsConfiguration( $self->{actionInstconfig}, $self->{options}, $self->{configfile} );
    } elsif ('remove_hosts' eq $action) {
        return new LCM::Configuration::Hosts::RemoveHosts::RemoveHostsConfiguration( $self->{options}, $self->{configfile} );
    } elsif ( !$isWin && ($action =~ m/^unregister_(system|instance)$/)) {
        # currently register scenario is supported only under linux
        return new LCM::Configuration::UnregisterConfiguration($action, $self->{options}, $self->{configfile});
	} elsif ('add_host_roles' eq $action) {
        return new LCM::Configuration::AddHostRolesConfiguration($self->{options}, $self->{configfile});
    } elsif ('remove_host_roles' eq $action) {
        return new LCM::Configuration::RemoveHostRolesConfiguration($self->{options}, $self->{configfile});
    } elsif ('update' eq $action) {
        return new LCM::Configuration::UpdateSystemBootstrapConfiguration($self->{options}, $self->{configfile});
    }

	return undef;
}

sub createExecutor {
	my ( $self, $action ) = @_;
	my $progressHandler = new LCM::ComponentProgressHandler();
	my $updateHostProgressHandler = new LCM::Gui::Dialogs::UpdateHosts::ProgressHandler();
	$updateHostProgressHandler->setParentProgressHandler($progressHandler);

    my $executor = undef;
    if ($self->isHelp()) {
        require LCM::Task::HelpProcessTask;
        return LCM::Task::HelpProcessTask->new($self->getInstconfig(), $self);
    } elsif ( "update_component_list" eq $action ) {
		require LCM::Task::UpdateComponentListProcessTask;
		$executor = new LCM::Task::UpdateComponentListProcessTask( $self->{instconfig} );
	} elsif ('add_hosts' eq $action) {
        require LCM::Task::AddHostsProcessTask;
        $executor = new LCM::Task::AddHostsProcessTask($self->{instconfig});
        $executor->addListener($progressHandler);
    } elsif ('remove_hosts' eq $action) {
        require LCM::Task::RemoveHostsProcessTask;
        $executor = new LCM::Task::RemoveHostsProcessTask($self->{instconfig});
        $executor->addListener($progressHandler);
    } elsif ('update_components' eq $action) {
    	require LCM::Task::GenericStackTask::UpdateProcessTask;
    	$executor = new LCM::Task::GenericStackTask::UpdateProcessTask( $self->{instconfig});
		$self->{instconfig}->{processTask} = $executor;
    } elsif ( !$isWin && (('rename_system' eq $action) || ('register_rename_system' eq $action) || ('continue_rename' eq $action)) ) {
        # currently rename scenario is supported only under linux
        require LCM::Task::RenameSystemProcessTask;
        $executor = new LCM::Task::RenameSystemProcessTask($self->{instconfig});
        $executor->addListener($progressHandler);
        $executor->addListener($updateHostProgressHandler);
    } elsif ('update' eq $action) {
        require LCM::Task::UpdateSystemBootstrapProcessTask;
        $executor = new LCM::Task::UpdateSystemBootstrapProcessTask($self->{instconfig});
        $executor->addListener($progressHandler);
    }
	return $executor;
}

sub getFlavour {
    my $self = shift;
    my $installer = new LCM::Installer();
    my $installation = $installer->getInstallation();
    return $installation->getHANAFlavour();
}

sub isResident {
    return 1;
}

1;
