package LCM::Gui::Dialogs::AcceleratorPropertiesDialog;

use SDB::Install::Gui::Design;
use SDB::Install::Globals qw ($gShortProductNameAccelerator $gNameAccelerator);
use base qw(SAPDB::Install::Wizard::Dialog::Base);
use strict;
use Wx qw(wxVERTICAL wxLEFT wxEXPAND wxALIGN_CENTER_VERTICAL wxBOTTOM wxALL wxTE_PASSWORD);

sub new{
    my($self) = shift->SUPER::new(@_);

    $self->{id} = 'AcceleratorProperties';
    $self->{label_text} = "Specify $gShortProductNameAccelerator Properties";
    $self->{name} = "Define $gShortProductNameAccelerator Properties";

    return $self;
}

sub init{
	my ($self,$config) = @_;
	my $app = Wx::wxTheApp();
	my $instconfig = $app->{instconfig};
	my $mainSizer = Wx::BoxSizer->new(wxVERTICAL);
	my $dialogTitle = Wx::StaticText->new($self, -1, $self->{label_text});
	my $gridSizer = Wx::FlexGridSizer->new(6, 2, 5, 15);

	$mainSizer->AddSpacer (20);
	$dialogTitle->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
	$mainSizer->Add($dialogTitle,0, wxLEFT , 20 );
	$mainSizer->Add ($gridSizer,0, wxEXPAND | (wxALL) & (~wxBOTTOM), 20);
	$self->_addParameterControls('AcceleratorUser', $gridSizer, $instconfig, 'string');
	$self->_addPasswordConfirmationControls('AcceleratorPassword', $gridSizer, $instconfig);
	$self->_addParameterControls('AcceleratorDataPath', $gridSizer, $instconfig, 'path');
	$self->_addParameterControls('AcceleratorLogPath', $gridSizer, $instconfig, 'path');

	$gridSizer->AddGrowableCol( 1 );
	$self->SetSizerAndFit($mainSizer);
	$self->SetAutoLayout(1);
	$self->Layout();
	$self->Show(1);

	return {}; 
}

sub _addPasswordConfirmationControls {
	my ($self, $parameterName, $gridSizer, $instconfig) = @_;

	# Nothing to create if parameter is skipped or not existent
	return unless(exists($instconfig->{params}->{$parameterName}));
	return if($instconfig->isSkipped($parameterName));
	return if($instconfig->isHidden($parameterName));

	my $parameter = $instconfig->{params}->{$parameterName};
	my $isMandatory = $parameter->{mandatory} ? 1 : 0;
	my $parameterValue = (defined $parameter->{value} ? $parameter->{value} : $instconfig->getDefault($parameterName));
	my $parameterString = $parameter->{str};
	$parameterValue = '' if(!defined($parameterValue));
	
	my $label = SDB::Install::Gui::Control::Label->new( $self, -1, $parameterString, $isMandatory);
	my $control = new Wx::TextCtrl ($self, -1, $parameterValue,[-1,-1], [-1,-1],wxTE_PASSWORD);
	$gridSizer->Add($label,0, wxALIGN_CENTER_VERTICAL);
	$gridSizer->Add($control, 1, wxEXPAND  );
	$self->{_uiControls}->{"_${parameterName}Label"} = $label;
	$self->{_uiControls}->{"_${parameterName}Control"} = $control;

	if($self->_shouldConfirmPassword($parameterName, $instconfig)){
		my $confirmationLabel = SDB::Install::Gui::Control::Label->new( $self, -1, "$parameterString Confirmation", $isMandatory);
		my $confirmationControl = new Wx::TextCtrl ($self, -1, $parameterValue,[-1,-1], [-1,-1],wxTE_PASSWORD);
		$gridSizer->Add($confirmationLabel,0, wxALIGN_CENTER_VERTICAL);
		$gridSizer->Add($confirmationControl, 1, wxEXPAND  );
		$self->{_uiControls}->{"_${parameterName}ConfirmationLabel"} = $confirmationLabel;
		$self->{_uiControls}->{"_${parameterName}ConfirmationControl"} = $confirmationControl;
	}
}

sub _shouldConfirmPassword {
	my ($self, $parameterName, $instconfig) = @_;
	return $instconfig->{params}->{$parameterName}->{type} eq 'initial_passwd';
}

sub _addParameterControls {
	my ($self, $parameterName, $gridSizer, $instconfig, $type) = @_;

	# Nothing to create if parameter is skipped or not existent
	return unless(exists($instconfig->{params}->{$parameterName}));
	return if($instconfig->isSkipped($parameterName));
	return if($instconfig->isHidden($parameterName));

	my $parameter = $instconfig->{params}->{$parameterName};
	my $parameterValue = (defined $parameter->{value} ? $parameter->{value} : $instconfig->getDefault($parameterName));
	my $isMandatory = $parameter->{mandatory} ? 1 : 0;
	my $isSkipped = $instconfig->isSkipped($parameterName);
	my $parameterString = $parameter->{str};
	
	return if($isSkipped);
	$parameterValue = '' if (!defined $parameterValue);
	
	my $label = SDB::Install::Gui::Control::Label->new($self, -1, $parameterString, $isMandatory);
	my $inputControl = $self->_createUserInputControl($type, $parameterValue);
	$label->SetToolTip ($parameter->{desc});
	$inputControl->SetToolTip($parameter->{desc});
	$gridSizer->Add($label,0, wxALIGN_CENTER_VERTICAL);
	$gridSizer->Add($inputControl, 1, wxEXPAND  );
	$self->{_uiControls}->{"_${parameterName}Label"} = $label;
	$self->{_uiControls}->{"_${parameterName}Control"} = $inputControl;
}

sub Process {
	my ($self,) = @_;
	my $app = Wx::wxTheApp();
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

	$instconfig->resetError ();
	if(!$self->_setAcceleratorUser($app, $instconfig)){
    	return undef;
    }
    if(!$self->_setAcceleratorPassword($app, $instconfig)){
    	return undef;
    }
    if(!$self->_setAcceleratorDataPath($app, $instconfig)){
    	return undef;
    }
    if(!$self->_setAcceleratorLogPath($app, $instconfig)){
    	return undef;
    }
	
	return {};
}

sub _setAcceleratorDataPath {
	my ($self, $app, $instconfig) = @_;
	my $dataPathControl = $self->{_uiControls}->{_AcceleratorDataPathControl};
    
    return 1 unless(defined($dataPathControl)); # Nothing to do if control does not exist
    
   	my $dataPathValue = $dataPathControl->GetValue();
    	
	if (! $instconfig->setValue('AcceleratorDataPath', $dataPathValue)) {
		$app->ShowErrorMsg( "Invalid value for Location of Data Volumes of the $gShortProductNameAccelerator", $instconfig->getErrMsgLst() );
		$dataPathControl->SetFocus();
		return undef;
	}
	return 1;
}

sub _setAcceleratorLogPath {
	my ($self, $app, $instconfig) = @_;
	my $logPathControl = $self->{_uiControls}->{_AcceleratorLogPathControl};
    
    return 1 unless(defined($logPathControl)); # Nothing to do if control does not exist
    
   	my $logPathValue = $logPathControl->GetValue();
    	
	if (! $instconfig->setValue('AcceleratorLogPath', $logPathValue)) {
		$app->ShowErrorMsg( "Invalid value for Location of Log Volumes of the $gShortProductNameAccelerator", $instconfig->getErrMsgLst() );
		$logPathControl->SetFocus();
		return undef;
	}
	return 1;
}

sub _setAcceleratorUser {
	my ($self, $app, $instconfig) = @_;
	my $userControl = $self->{_uiControls}->{_AcceleratorUserControl};

    return 1 unless(defined($userControl)); # Nothing to do if control does not exist

   	my $userValue = $userControl->GetValue();
	if (! $instconfig->setValue('AcceleratorUser', $userValue)) {
		$app->ShowErrorMsg( "Invalid $gNameAccelerator Administrator User value", $instconfig->getErrMsgLst() );
		$userControl->SetFocus();
		return undef;
	}
	return 1;
}

sub _setAcceleratorPassword {
	my ($self, $app, $instconfig) = @_;
	my $passwordControl = $self->{_uiControls}->{_AcceleratorPasswordControl};
	my $shouldConfirmPassword = $self->_shouldConfirmPassword('AcceleratorPassword', $instconfig);
    my $passwordConfirmationControl = $self->{_uiControls}->{_AcceleratorPasswordConfirmationControl};
	
	# Nothing to do if controls do not exist
	return 1 unless(defined($passwordControl) && (! $shouldConfirmPassword || defined($passwordConfirmationControl)));
	
	my $passwordValue = $passwordControl->GetValue();
		
	if(! $passwordValue) {
		$app->ShowErrorMsg( "$gNameAccelerator Administrator Password is empty" );
	    $passwordControl->SetFocus();
	    return undef;
	}
    	
	if(! $instconfig->setValue('AcceleratorPassword', $passwordValue)) {
		$app->ShowErrorMsg( "$gNameAccelerator Administrator Password value", $instconfig->getErrMsgLst() );
		$passwordControl->SetFocus();
		return undef;
	}

	if($shouldConfirmPassword){
		my $passwordConfirmationValue = $passwordConfirmationControl->GetValue();
		if($passwordValue ne $passwordConfirmationValue) {
			$app->ShowErrorMsg( "Password confirmation doesn't match" );
			$passwordControl->SetFocus();
			return undef;
		}
	}

	return 1
}

sub _createUserInputControl {
	my ($self, $type, $value) = @_;
	if($type eq 'path'){
		return new SAPDB::Install::Control::PathCtrl($self, -1, $value, [-1,-1], [-1,-1]);
	} elsif ($type eq 'password') {
		return new Wx::TextCtrl($self, -1, $value,[-1,-1], [-1,-1], wxTE_PASSWORD);
	} else {
		return new Wx::TextCtrl($self, -1, $value,[-1,-1], [-1,-1]);
	}
}

sub Back{
	my ($self) = @_;
	$self->Reset();
}

sub Reset{
	my ($self) = @_;
    
    if(defined $self->GetSizer()){
        $self->GetSizer->Clear (1);
    }
	delete($self->{_uiControls});
	$self->SUPER::Reset();
}

sub Destroy{
	my ($self) = @_;
	$self->Reset();
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;