package LCM::Gui::Dialogs::AddHostRoles::AddHostRolesPanel;

use strict;
use parent 'LCM::Gui::Dialogs::HostsPanel';
use Wx qw (wxVERTICAL wxHORIZONTAL wxALIGN_CENTER_VERTICAL wxDefaultPosition wxTE_PASSWORD wxGROW wxEXPAND wxDefaultSize  wxLIST_AUTOSIZE_USEHEADER wxALIGN_LEFT);
use Wx::Event qw (EVT_BUTTON EVT_LIST_ITEM_SELECTED EVT_LIST_ITEM_DESELECTED);
use LCM::Gui::Dialogs::HostsPanelTableListener qw(OnListItemSelected InsertListItem GetListItem UpdateListItem);
use LCM::Gui::DialogUtilities qw(GetAppConfig);
use LCM::HostsUtility qw ( IsHostPartOfSystem);

sub newFieldsSizer {
    my ($self) = @_;
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();
    return $self->fieldsSizer($instconfig);
}

sub fieldsSizer {
    my ($self, $instconfig, ) = @_;
    my $window = $self->getWindow();
    my $sizer = new Wx::FlexGridSizer(3, 2, 5, 10);

    $window->{_fieldsSizer} = $sizer;
    $sizer->SetFlexibleDirection(wxHORIZONTAL);
    $sizer->AddGrowableCol(1);

    if($instconfig->isDistributedSystem()){
        $self->_addParamInput('RootUser', $instconfig, $sizer);
        $self->_addParamInput('RootPassword', $instconfig, $sizer);
    }
    $self->_addParamInput('Password', $instconfig, $sizer);
    return $sizer;
}

sub newAddHostsSizer {
    my ( $self ) = @_;
    my $sizer = new Wx::BoxSizer(wxVERTICAL);
    $self->addHostRolesPanel($sizer);
    return $sizer;
}

sub addHostRolesPanel {
    my ($self, $sizer) = @_;

    my $window = $self->getWindow();
    my $hostsList = $self->createHostsListCtrl($window);
    $self->addWindowControl( 'HostsList',  $hostsList);
    $sizer->Add( $hostsList, 1, wxEXPAND | wxGROW);

    $sizer->AddSpacer(10);

    EVT_LIST_ITEM_SELECTED($window, $hostsList->GetId, \&OnListItemSelected );
    my $buttonsSizer = Wx::BoxSizer->new(wxHORIZONTAL);

    my $editRolesButton = new SDB::Install::Gui::Control::Button($window, -1, '&Assign Roles...', wxDefaultPosition, wxDefaultSize);
    $self->addWindowControl( 'editRolesBtn',  $editRolesButton);
    $editRolesButton->Enable(0);
    EVT_BUTTON($window,$editRolesButton->GetId, sub { $self->_onAssignRoles(@_); });
    $buttonsSizer->Add( $editRolesButton, 0 );

    EVT_LIST_ITEM_DESELECTED($window, $hostsList, sub {
        $editRolesButton->Enable(0);
    });
    $sizer->Add($buttonsSizer, 0 , wxALIGN_LEFT);

    return $sizer;
}

# Does not need to modify RootUser visibility in page like it's parent
sub setFieldProperties{
    return;
}

sub createHostsListCtrl {
    my($self, $window) = @_;
    my $list = $self->_createListCtrl();
    my $column_index = 0;

    $list->{minColWidths} = [150, 400];
    $list->InsertColumn($column_index, "Hostname");
    $list->SetColumnWidth($column_index++, wxLIST_AUTOSIZE_USEHEADER);
    $list->InsertColumn($column_index, "Role(s)");
    $list->SetColumnWidth($column_index++, wxLIST_AUTOSIZE_USEHEADER);

    return $list;
}

sub _onAssignRoles {
    my ($self, $window) = @_;
    &OnAssignRoles($window);
}

# Overwrites HostsPaneLTableListener method
sub OnAssignRoles {
    my ($window) = @_;

    my $itemIndex = $window->{selectedItemIndex};

    my $host = GetListItem( $window, $itemIndex );

    require LCM::Gui::Dialogs::AddHostRoles::AdditionalRolesDialog;
    my $dlg = new LCM::Gui::Dialogs::AddHostRoles::AdditionalRolesDialog($window, $host->getHost());
    my $primaryRole = (split(',', $host->getRole()))[0];
    $dlg->setPrimaryHostRole($primaryRole);
    my $isLocalHost = 1;
    $dlg->handleSelectedHostRolesCB( $host, $isLocalHost );

    my $retCode = $dlg->ShowModal();
    $dlg->Destroy();
    if ( $retCode != $dlg->GetAffirmativeId() ) {
        return;
    }

    $host->{role} = $dlg->getCSVRoles();
    my $checkListValidity = 0;
    UpdateListItem( $window, $itemIndex, $host, $checkListValidity );
}

1;