#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Configuration dialog => Additional System

package LCM::Gui::Dialogs::AdditionalSystemDialog;

use SDB::Install::Globals qw ($gHostRoleWorker $gHostRoleXS2Standby $gHostRoleXS2Worker $gKeynameXS2);
use SDB::Install::Gui::Dialogs::SystemProperties;
use SDB::Install::SysVars qw ($isWin);
use SDB::Install::Configuration qw($bool_true_pattern);
use experimental qw (smartmatch);
use LCM::Component;
use SDB::Install::Gui::Design;

use Wx qw( wxHORIZONTAL wxALIGN_CENTER_VERTICAL wxEXPAND wxOK wxCENTRE wxICON_EXCLAMATION wxVERTICAL wxALIGN_TOP wxLEFT wxBOTTOM);
use Wx::Event qw ( EVT_BUTTON );
our @ISA = qw (SDB::Install::Gui::Dialogs::SystemProperties);

use strict;

our $paramKeys = [];
our $addLocalRolesBtn = undef;

sub getParamKeys{
    return $paramKeys;
}

sub _getValueFromMixedComboBox {
	my ($self, $ctrl) = @_;
	my $value = $ctrl->GetValue();
	$value =~ s/^\s*.* - \s*(\w.*\w)\s*/$1/;
	return $value;
}

sub addControls {
	my ($self, $sizer) = @_;
	my $instconfig = Wx::wxTheApp()->getInstconfig();

	if(!$self->_isXs2Selected() || $self->_isAddingXsHost()){
		my $result = $self->SUPER::addControls($sizer);
		$self->_enableAdditionalUIControls($instconfig);
		return $result;
	}

	my $param = $instconfig->{params}->{'AutoAddXS2Roles'};
	$self->{'AutoAddXS2Roles_ctrl'} = new Wx::CheckBox ($self, -1,$param->{'str'}, [-1,-1], [-1,-1]);
	$self->{'AutoAddXS2Roles_ctrl'}->SetFont (SDBFONT_NormalText) if (!Wx::wxGTK1());
	my $value = $instconfig->hasValue('AutoAddXS2Roles') ? $instconfig->getValue('AutoAddXS2Roles') : 1;
	$self->{'AutoAddXS2Roles_ctrl'}->SetValue($value);
	my $boxsizer = new Wx::BoxSizer(wxVERTICAL);
	$boxsizer->AddSpacer(10);
	$boxsizer->Add($self->{'AutoAddXS2Roles_ctrl'}, 0, wxEXPAND | wxALIGN_TOP);
	$sizer->Add($boxsizer,0 , wxEXPAND | wxLEFT, 20);

	my $result = $self->SUPER::addControls($sizer);
	$self->_enableAdditionalUIControls($instconfig);
	return $result;
}

sub _enableAdditionalUIControls {
	my ($self, $instconfig) = @_;
	my $ctrl;
	for my $paramId ('AutoStart', 'RestrictMaxMem'){
		$ctrl = $self->getParamCtrl ($paramId);
		next if(!defined $ctrl);
		my $isEnabled = $instconfig->isSkipped($paramId) ? 0 : 1;
		$ctrl->Enable($isEnabled);
	}
}

sub init {
	my ($self) = @_;
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    $self->initParamKeys( $instconfig );
	$self->{addLocalRoles} = $gHostRoleWorker;

    my $rc = $self->SUPER::init($instconfig);
 	if( !defined $rc->{'errstate'} ){
	    $self->{'grid_sizer'}->AddSpacer (15);
		my $componentManager = $instconfig->getComponentManager();
		if ( $componentManager->isHanaOptionSelected() ) {
			splice ( @$paramKeys, 0, 0, 'HostName' );

			my $additionalRoles = $instconfig->getValue("AddLocalRoles");
			if(defined($additionalRoles) && ! $instconfig->isSkipped("AddLocalRoles")) {
				$self->{addLocalRoles} .= ",$additionalRoles";
			}

			my $onAddLocalHostRoles = sub { $self->OnAddLocalHostRoles() };
			(my $textCtrl, $addLocalRolesBtn) = $self->addTextCtrltWithBtn( $self->{'grid_sizer'}, 0, $instconfig, 'HostName', "Add Local Roles ...", $onAddLocalHostRoles);
			$addLocalRolesBtn->SetToolTip($instconfig->getCSVRoleDescriptiveNames( $self->{addLocalRoles} ) );
		}
	    my $ctrl;
	    for my $paramId ('AutoStart', 'RestrictMaxMem', 'MaxMem') {
            $ctrl = $self->getParamCtrl ($paramId);
	        next unless(exists($instconfig->{params}->{$paramId}) && defined ($instconfig->{params}->{$paramId}));
	        next if (!defined $ctrl);
	        my $param = $instconfig->{params}->{$paramId};
	        if(!defined($param->{value})){
	            # parameter was not previously initialized with any value
	            $instconfig->setBatchValue($paramId);
	        }
	        my $value = (defined $param->{value} ? $param->{value} : $instconfig->getDefault($paramId));
	        $ctrl->SetValue($value);
	    }
	    $ctrl = $self->getParamCtrl('MaxMem');
	    if (defined  $ctrl) {
	        $ctrl->Enable($instconfig->getValue('RestrictMaxMem'));
	    }
    }
    $self->_handleAutoAddCheckBox($self->{addLocalRoles});

	$self->{INITIALIZED} = 1;
    return $rc;
}

sub Back {
	my ($self) = @_;
	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $componentManager = $instconfig->getComponentManager();

	if ( $componentManager->isHanaOptionSelected() ) {
		my $sizer = $self->{'grid_sizer'};
		$self->{boxsizer}->Detach ($self->{dynctrl}->{'HostName_ctrl'});
		$self->{boxsizer}->Detach ($self->{button});
		$sizer->Detach ($self->{boxsizer});
		$self->{boxsizer}->Destroy();
		$self->{button}->Destroy();
		delete $self->{boxsizer};
		delete $self->{button};
	}
	my $controlId = 'AutoAddXS2Roles_ctrl';
	if (exists($self->{$controlId})){
		$self->{$controlId}->Destroy();
		delete($self->{$controlId});
	}
	$self->SUPER::Back();
}

sub initParamKeys{
    my ($self, $instconfig) = @_;

	my $componentManager = $instconfig->getComponentManager();
	my @hostname = $componentManager->isHanaOptionSelected() ? () : ('HostName');
	
    my $isDistributedSystem = $instconfig->isDistributedSystem();
    my @target = ($isWin or $isDistributedSystem) ? () : ('Target');
    my @drive = $isWin ? 'Drive' : ();
    my @dbIsolation = $isWin ? () : 'DbIsolation';

    $paramKeys = [@hostname, @target, 'SID', 'InstanceNumber', @drive, 'WorkerGroup', 'DbMode', @dbIsolation, 'SystemUsage', 'VolumeEncryption'];
}

sub addTextCtrltWithBtn {
    my ($self, $sizer, $index, $instconfig, $param_id, $btnLabel, $button_handler) = @_;
	my $sizerItem = $sizer->GetItem($index);

	my $param = $instconfig->{params}->{$param_id};
	my $label = $self->{$param_id . '_label'} = SDB::Install::Gui::Control::Label->new ( $self, -1, $param->{'str'});
	$sizer->Insert($index++, $label, 0, wxALIGN_CENTER_VERTICAL);

	my $value = (defined $param->{value} ? $param->{value} : $instconfig->getDefault ($param_id));
	if (!defined $value){
		$value = '';
	}

	my $textCtrl = Wx::TextCtrl->new( $self, -1, $value );
	my $button = SDB::Install::Gui::Control::Button->new( $self, -1, $btnLabel, [0,0], [-1,-1] );
    EVT_BUTTON( $self, $button->GetId, $button_handler );

	my $text_width = -1;
	if ($text_width > 0){
		$text_width -= $button->GetSize()->GetWidth ();
		$textCtrl->SetMinSize ([$text_width,-1]);
	}
	$self->{dynctrl}->{$param_id . '_ctrl'} = $textCtrl;

    my $boxsizer = new Wx::BoxSizer( wxHORIZONTAL );
	$boxsizer->Add( $textCtrl, 1, wxALIGN_CENTER_VERTICAL );
	$boxsizer->Add( $button );
    $sizer->Insert( $index, $boxsizer, 1, wxEXPAND );

    $self->{boxsizer} = $boxsizer;
    $self->{button} = $button;

	if ( $sizerItem->IsWindow() ) {
		$button->MoveBeforeInTabOrder($sizerItem->GetWindow());
		$textCtrl->MoveBeforeInTabOrder($button);
	}
    return ($textCtrl, $button);
}

sub OnAddLocalHostRoles {
	my ($self) = @_;

    my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $localHost = $instconfig->getLocalHanaHost();
	
	require LCM::Gui::Dialogs::AdditionalRolesDialog;
	my $dlg = new LCM::Gui::Dialogs::AdditionalRolesDialog($self, $localHost);
	$dlg->setPrimaryHostRole($gHostRoleWorker);
	$dlg->handleSelectedHostRoles( $self->{addLocalRoles}, 1 );
	$dlg->handleRolesAccessability( $localHost, $gHostRoleWorker, 1 );

	my $retCode = $dlg->ShowModal();
	$dlg->Destroy();
	if ( $retCode != $dlg->GetAffirmativeId() ) {
		return;
	}

	my $additionalRolesCSV = $dlg->getCSVRoles();
	$self->{addLocalRoles} = $additionalRolesCSV;
	my $descriptiveRoleNames = $instconfig->getCSVRoleDescriptiveNames( $self->{addLocalRoles}, ', ');
	$addLocalRolesBtn->SetToolTip($descriptiveRoleNames);
	$self->_handleAutoAddCheckBox($additionalRolesCSV);
}

sub _handleAutoAddCheckBox {
	my ($self, $additionalRolesCSV) = @_;
	my $uiControl = $self->{'AutoAddXS2Roles_ctrl'};

	return if(!defined($uiControl));

	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $shouldDisable = $self->_shouldDisableAutoAddXS2Roles($additionalRolesCSV);
	my $value = $instconfig->hasValue('AutoAddXS2Roles') ? $instconfig->getValue('AutoAddXS2Roles') : 1;
	$uiControl->Enable($shouldDisable ? 0 : 1);
	$uiControl->SetValue($shouldDisable ? 0 : $value);
}

sub _isXs2Selected {
	my ($self) = @_;
	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $componentManager = $instconfig->getComponentManager();
	my $xs2Component = $componentManager->getComponentByKeyName($gKeynameXS2);

	return defined($xs2Component) && $xs2Component->isComponentSelected();
}

sub _isAddingXsHost {
	my ($self) = @_;
	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $addHosts         = $instconfig->getValue('AddHosts');
	my @hostsForAddition = (!defined $addHosts || $instconfig->isSkipped('AddHosts')) ? () : split(',', $addHosts);
	my $isAddingXsHost = grep { $_ =~ /:role=($gHostRoleXS2Worker|$gHostRoleXS2Standby)/} @hostsForAddition;

	return $isAddingXsHost;
}

sub _isAddingXsRole {
	my ($self, $addLocalRoles) = @_;
	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my @rolesForAddition = split(',', $addLocalRoles);
	my $isAddingLocalXsRole = grep { $_ =~ /$gHostRoleXS2Worker|$gHostRoleXS2Standby/} @rolesForAddition;

	return $isAddingLocalXsRole;
}

sub _shouldDisableAutoAddXS2Roles {
	my ($self, $addLocalRoles) = @_;
	return 1 if(!$self->_isXs2Selected());
	return 1 if($self->_isAddingXsHost());
	return 1 if($self->_isAddingXsRole($addLocalRoles));
	return 0;
}

sub Process{
	my ($self,$config) = @_;
	my $instconfig = Wx::wxTheApp()->getInstconfig();
	my $componentManager = $instconfig->getComponentManager();

	if ( $componentManager->isHanaOptionSelected() ){
		if ( $self->{addLocalRoles} eq $gHostRoleWorker ){
			$instconfig->setSkip ("AddLocalRoles", 1);
			$instconfig->setSkip('AutoAddXS2Roles', $instconfig->_shouldSkipAutoAddXS2Roles());
		} else {
			$instconfig->setSkip ("AddLocalRoles", 0);
			my $addLocalRolesValue = join(',', grep { not ($_ ~~ [$gHostRoleWorker]) } split(',', $self->{addLocalRoles}));
			if ( !$instconfig->setValue ("AddLocalRoles", $addLocalRolesValue)){
				Wx::MessageBox( "Checking " .  $instconfig->{params}->{AddLocalRoles}->{str} . " failed.\n" . $instconfig->GetErrorString (), 
					"Configuration Error", wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
				$addLocalRolesBtn->SetFocus() if defined $addLocalRolesBtn;
		    	return undef;
			}
		}
	}

    my $rc = $self->SUPER::Process ($config);
    my $ctrl;
    foreach my $param_id ('AutoStart', 'RestrictMaxMem', 'EnableXSEngine'){
        my $param = $instconfig->{params}->{$param_id};
        $ctrl = $self->getParamCtrl ($param_id);
        # skip if there is no such control added for this parameter or parameter is not interactive
        next if (!defined $param || !defined $ctrl);
        next if (defined($param->{set_interactive}) && !$param->{set_interactive});
        $param->{value} = $ctrl->GetValue() ? 1 : 0;
    }

    my $app = Wx::wxTheApp();
	if($rc && ! $instconfig->isSkipped('AutoAddXS2Roles') && defined($self->{'AutoAddXS2Roles_ctrl'})){
		my $uiControl = $self->{'AutoAddXS2Roles_ctrl'};
		my $parameter = $instconfig->{params}->{AutoAddXS2Roles};
		my $value = $uiControl->IsChecked() ? 1 : 0;

		if(! $instconfig->setValue('AutoAddXS2Roles', $value)) {
			$app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
			return undef;
		}
	}

	if($rc && ! $instconfig->isSkipped('LSSTrustUnsignedServer')){
		my $value = $instconfig->getBatchValue('LSSTrustUnsignedServer');
		if(! $instconfig->setValue('LSSTrustUnsignedServer', $value)) {
			$app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
			return undef;
		}
	}

    my $restrictMaxMem = $instconfig->{params}->{RestrictMaxMem}->{value};
    if (defined $restrictMaxMem && ($restrictMaxMem =~ /$bool_true_pattern/i)){
        $ctrl = $self->getParamCtrl ('MaxMem');
        $instconfig->{params}->{MaxMem}->{value} = $ctrl->GetValue();
    } else {
        $instconfig->{params}->{MaxMem}->{value} = 0;
    }
    $self->GetWizard()->RefreshSkippableDialogs();
    return $rc;
}

1;
