package LCM::Gui::Dialogs::BootstrapDelegationDialog;
use base qw (SAPDB::Install::Wizard::Dialog::Base);
use warnings;
use strict;

use SDB::Install::Globals qw ($gProductNameHLM);
use SDB::Install::Gui::Design;
use Wx qw(wxVERTICAL wxCENTRE);

sub new {
    my $self = shift->SUPER::new(@_);
    $self->{id}   = 'BootstrapDelegationDialog';
    $self->{name} = "Delegating Execution";
    return $self;
}

sub init {
    my ($self) = @_;
    return {auto_next => 1};
}

sub BackInit {
    my ($self) = @_;
    return {auto_back => 1};
}

sub Process {
    my ($self) = @_;
    my $mainSizer = Wx::BoxSizer->new(wxVERTICAL);

    my $captionText = "Starting $gProductNameHLM from specified installation kit...";
    my $staticText = Wx::StaticText->new($self, -1, $captionText, [0,0], [-1,-1]);
    $staticText->SetFont(SDBFONT_DialogTitle) if (!Wx::wxGTK1());

    $mainSizer->AddStretchSpacer();
    $mainSizer->Add($staticText, 0, wxCENTRE);
    $mainSizer->AddStretchSpacer();

    $self->SetSizer($mainSizer);
    $self->SetAutoLayout(1);
    $self->Layout();
    $self->GetWizard()->EnableNavigationControls(0);
    Wx::Yield();
    sleep(5);
    return {};
}

1;
