package LCM::Gui::Dialogs::Cockpit::CockpitStackController;

use strict;
use LCM::Gui::Dialogs::Cockpit::CockpitStackPropertiesDialog;
use LCM::Gui::Dialogs::Cockpit::CockpitTenantCredentialsDialog;
use LCM::Gui::Dialogs::UpgradeParameterDialog;
use LCM::Gui::Dialogs::XSPropertiesDialog;
use LCM::Gui::Dialogs::Update::XSTenantDatabaseCredentialsDialog;
use LCM::Gui::Dialogs::Cockpit::CockpitTenantCredentialsDialog;
use LCM::Gui::PagePredicates qw ( ShouldSkipCockpitStackPropertiesDialog ShouldSkipCockpitTenantCredentialsDialog);
use SDB::Install::Configuration qw($bool_true_pattern);

use parent 'LCM::Gui::Controllers::UpdateController';


sub getCondensedSteps {
    my $self = shift;
    my $wizard = $self->getWizard ();
    my $condensedSteps = [
        new LCM::Gui::Dialogs::Update::AdditionalHostsPropertiesDialog($wizard),
        new LCM::Gui::Dialogs::UpgradeParameterDialog($wizard),
        new LCM::Gui::Dialogs::XSPropertiesDialog($wizard),
        new LCM::Gui::Dialogs::Update::XSTenantDatabaseCredentialsDialog($wizard),
        new LCM::Gui::Dialogs::Cockpit::CockpitStackPropertiesDialog($wizard),
        new LCM::Gui::Dialogs::Cockpit::CockpitTenantCredentialsDialog($wizard),
    ];
    return $condensedSteps;
}

sub getMapDialogIdToSkipPredicates {
    my $map = shift->SUPER::getMapDialogIdToSkipPredicates();
    $map->{'CockpitStackPropertiesDialog'} = sub { ShouldSkipCockpitStackPropertiesDialog() };
    $map->{'CockpitTenantCredentilsDialog'} = sub {ShouldSkipCockpitTenantCredentialsDialog() };
    $map->{'SelectComponents'} = sub {
        my $app = Wx::wxTheApp;
        my $config = $app->getInstconfig();
        my $isUsingSimpleUI = !$config->isSkipped('UseSimpleUI') && $config->getBatchValue('UseSimpleUI') =~ /$bool_true_pattern/;
        return !$config->isInteractive('SelectedComponents') || $isUsingSimpleUI;
    };
    return $map;
}

1;