package LCM::Gui::Dialogs::Cockpit::CockpitStackPropertiesDialog;

use strict;
use warnings;
use Wx qw (
        wxEXPAND
        wxTOP
        wxHORIZONTAL
        wxBOTTOM
        wxLEFT
        wxALL
        );

use parent 'SDB::Install::Gui::Dialogs::GenericParameter';

use constant COCKPIT_TENANT_PARAMID => 'CockpitTenant';

sub new {
    my ( $self ) = shift->SUPER::new( @_ );
    $self->{id}         = 'CockpitStackPropertiesDialog';
    $self->{label_text} = "Specify Cockpit Properties";
    $self->{name}       = "Define Cockpit Properties";
    return $self;
}

sub getParamKeys {
    my ( $self ) = @_;
    return ['CockpitXSSpace'];
}


sub addControls{
    my ($self,$sizer) = @_;
    $self->addCockpitTenantPlaceHolder($sizer);
    return 1;
}

sub addCockpitTenantPlaceHolder{
    my ($self,$sizer) = @_;
    my $app = Wx::wxTheApp();
    my $config = $app->getInstconfig();

    my $cockpitTenantLabel = $self->{dynctrl}->{COCKPIT_TENANT_PARAMID . '_label'} = SDB::Install::Gui::Control::Label->new ( $self, -1, $config->getString(COCKPIT_TENANT_PARAMID),0);
    my $cockpitTenantInput = $self->{dynctrl}->{COCKPIT_TENANT_PARAMID . '_ctrl'} = new Wx::TextCtrl ( $self, -1, $config->getDefault(COCKPIT_TENANT_PARAMID),[-1,-1], [-1,-1]);

    my $placeholder_sizer = Wx::FlexGridSizer->new(1, 2, 5, 15);
    $sizer->Add($placeholder_sizer, ,0, wxEXPAND | (wxALL) & (~wxTOP), 20);
    $placeholder_sizer->AddSpacer(1);
    $placeholder_sizer->AddSpacer(1);
    $placeholder_sizer->Add($cockpitTenantLabel,0, wxTOP, 8);
    $placeholder_sizer->Add($cockpitTenantInput, 1, wxEXPAND | wxLEFT, 3);
    $placeholder_sizer->AddGrowableCol( 1 );

}

sub Process{
    my ($self,$config) = @_;
    my $returnHash = $self->SUPER::Process($config);
    if(defined $returnHash){
        my $app = Wx::wxTheApp();
        my $instconfig = $app->getInstconfig();
        return undef if(!$self->processParameter(COCKPIT_TENANT_PARAMID,$instconfig));
    }
    $self->GetWizard()->RefreshSkippableDialogs();
    return $returnHash;
}

sub DirectNavigationAllowed ($) {0}
1;