package LCM::Gui::Dialogs::Cockpit::SelectActivityCockpitExternalDialog;
use parent qw(LCM::Gui::Dialogs::SelectActivityExternalDialog);

use SDB::Install::Globals qw($gProductNameEngine $gProductNameCockpit $gFlavourPlatform);
use Wx qw (wxHORIZONTAL wxLEFT wxRIGHT wxDefaultPosition wxDefaultSize wxALIGN_CENTER_VERTICAL wxEXPAND);
use LCM::Gui::Dialogs::UiComponentsFactory qw(CreateRadioButton CreateComboBox);
use SDB::Install::Globals qw($gKeynameXS2);
use Wx::Event qw (EVT_RADIOBUTTON EVT_COMBOBOX);
use LCM::Gui::Dialogs::Cockpit::CockpitOnPlatformSummaryDialog;

sub _createInstallControls {
    my ( $self, $is_gtk1 ) = @_;
    my $leftInnerSizer = $self->{leftInnerSizer};

    $self->{'rb_install'} = CreateRadioButton($self, "&Install New $gProductNameCockpit System", $is_gtk1); 
    $leftInnerSizer->Add($self->{'rb_install'},0, wxEXPAND|wxRIGHT, 20);
    $leftInnerSizer->AddSpacer(30);
    EVT_RADIOBUTTON ($self, $self->{'rb_install'}->GetId(), \&OnRBInstall);
}

sub createSystemsControls{
    my $self = shift;
    $self->SUPER::createSystemsControls();
    if($self->hasHDBSystems()){
        if($self->hasNoCockpitHDBSystems()){
            $self->createInstallOnHDBControls();
        }
        if($self->hasCockpitOnHDBSystems()){
            $self->createUpdateOnHDBControls();
        }
        my @existingHDB = $self->getExistingHanaSystems();
        for my $row (@existingHDB){
            if($self->getSystemCollection()->hasCockpitStack($row)){
                $self->{'cb_hdb_update'}->Append($row);
                $self->{'cb_hdb_update'}->SetSelection(0);
            } else {
                $self->{'cb_hdb_install'}->Append($row);
                $self->{'cb_hdb_install'}->SetSelection(0);
            }
        }
    }
    EVT_RADIOBUTTON ($self, $self->{'rb_pendingInstall'}->GetId(), \&OnRBPendingInstall) if(defined  $self->{'rb_pendingInstall'});
    EVT_RADIOBUTTON( $self, $self->{'rb_update'}->GetId(), \&OnRBUpdate ) if(defined  $self->{'rb_update'});;
}

sub createUpdateOnHDBControls {
    my ( $self, $is_gtk1 ) = @_;
    my $leftInnerSizer = $self->{leftInnerSizer};

    $self->{'rb_hdb_update'} = CreateRadioButton($self, "&Update on $gProductNameEngine",  $is_gtk1 );
    $leftInnerSizer->Add( $self->{'rb_hdb_update'}, 0, wxEXPAND|wxRIGHT, 20 );
    $leftInnerSizer->AddSpacer( 12 );
    EVT_RADIOBUTTON( $self, $self->{'rb_hdb_update'}->GetId(), \&OnRBUpdateCockpitHDB );

    $self->{'lb_hdb_update'} = new Wx::StaticText( $self,-1,"Select system:", wxDefaultPosition, wxDefaultSize );
    $self->{'cb_hdb_update'} = CreateComboBox($self, '', $is_gtk1, new Wx::Size(100, -1), new Wx::Size(100, -1));
    EVT_COMBOBOX( $self, $self->{'cb_hdb_update'}->GetId(), \&OnComboBoxUpdateCockpitHDB );

    my $update_sizer = new Wx::BoxSizer( wxHORIZONTAL );
    $update_sizer->Add( $self->{'lb_hdb_update'},0, wxALIGN_CENTER_VERTICAL );
    $update_sizer->Add( $self->{'cb_hdb_update'},0,  wxLEFT | wxRIGHT,10 );
    
    $leftInnerSizer->Add( $update_sizer, 0 , wxLEFT, 20 );
    $leftInnerSizer->AddSpacer( 30 );

}

sub createInstallOnHDBControls {
    my ( $self, $is_gtk1 ) = @_;
    my $leftInnerSizer = $self->{leftInnerSizer};

    $self->{'rb_hdb_install'} = CreateRadioButton($self, "&Install on $gProductNameEngine",  $is_gtk1 );
    $leftInnerSizer->Add( $self->{'rb_hdb_install'}, 0, wxEXPAND|wxRIGHT, 20 );
    $leftInnerSizer->AddSpacer( 12 );
    EVT_RADIOBUTTON( $self, $self->{'rb_hdb_install'}->GetId(), \&OnRBInstallCockpitHDB );

    $self->{'lb_hdb_install'} = new Wx::StaticText( $self,-1,"Select system:", wxDefaultPosition, wxDefaultSize );
    $self->{'cb_hdb_install'} = CreateComboBox($self, '', $is_gtk1, new Wx::Size(100, -1), new Wx::Size(100, -1));
    EVT_COMBOBOX( $self, $self->{'cb_hdb_install'}->GetId(), \&OnComboInstallCockpitHDB );

    my $update_sizer = new Wx::BoxSizer( wxHORIZONTAL );
    $update_sizer->Add( $self->{'lb_hdb_install'},0, wxALIGN_CENTER_VERTICAL );
    $update_sizer->Add( $self->{'cb_hdb_install'},0,  wxLEFT | wxRIGHT,10 );
    
    $leftInnerSizer->Add( $update_sizer, 0 , wxLEFT, 20 );
    $leftInnerSizer->AddSpacer( 30 );
}

sub OnRBUpdateCockpitHDB{
    my ($self, $evt) = @_;
    $self->enableCockpitHDBUpdate(1);
    $self->enableCockpitHDBInstall(0);
    $self->_enableUpdateUi(0);
    $self->_enablePendingInstallUi(0);
    $self->_fillSystemDescription();
}

sub OnComboBoxUpdateCockpitHDB{
    my ($self, $evt) = @_;
    $self->_fillSystemDescription();
}

sub OnRBInstallCockpitHDB{
    my ($self, $evt) = @_;
    $self->enableCockpitHDBInstall(1);
    $self->enableCockpitHDBUpdate(0);
    $self->_enableUpdateUi(0);
    $self->_enablePendingInstallUi(0);
    $self->_fillSystemDescription();
}

sub OnComboInstallCockpitHDB{
    my ($self, $evt) = @_;
    $self->_fillSystemDescription();
}

sub enableCockpitHDBUpdate{
    my ($self,$enable) = @_;
    return if(!$self->hasCockpitOnHDBSystems());
    $self->{'lb_hdb_update'}->Enable($enable);
    $self->{'cb_hdb_update'}->Enable($enable);
}

sub enableCockpitHDBInstall{
    my ($self,$enable) = @_;
    return if(!$self->hasNoCockpitHDBSystems());
    $self->{'lb_hdb_install'}->Enable($enable);
    $self->{'cb_hdb_install'}->Enable($enable);
} 

sub getSelectedSID{
    my $self = shift;
    my $value = undef;
    if($self->hasHDBSystems()){
         if(defined $self->{'cb_hdb_install'} && $self->{'cb_hdb_install'}->IsEnabled()){
             $value = $self->{'cb_hdb_install'}->GetValue();
         }
         if(defined $self->{'cb_hdb_update'} && $self->{'cb_hdb_update'}->IsEnabled()){
             $value = $self->{'cb_hdb_update'}->GetValue();
         }
    }

    return $value if(defined $value);
    return $self->SUPER::getSelectedSID();
}

sub hasHDBSystems{
    my $self = shift;
    if(!defined $self->{hasHDB}){
        my $collection = $self->getSystemCollection();
        my @hanaSystems = $self->getExistingHanaSystems();
        $self->{hasHDB} = scalar @hanaSystems > 0 ? 1 : 0;
    }
    return $self->{hasHDB};
}

sub _selectUpdate{
    my($self) = @_;
    if($self->hasHDBSystems()){
        $self->{'rb_hdb_update'}->SetValue(0) if(defined $self->{'rb_hdb_update'});
        $self->{'rb_hdb_install'}->SetValue(0) if(defined $self->{'rb_hdb_install'});
        $self->enableCockpitHDBInstall(0);
        $self->enableCockpitHDBUpdate(0);
    }
    $self->SUPER::_selectUpdate();
}

sub _selectInstall{
    my ($self) = @_;
    if($self->hasHDBSystems()){
        $self->{'rb_hdb_update'}->SetValue(0) if(defined $self->{'rb_hdb_update'});
        $self->{'rb_hdb_install'}->SetValue(0) if(defined $self->{'rb_hdb_install'});
        $self->enableCockpitHDBInstall(0);
        $self->enableCockpitHDBUpdate(0);
    }
    $self->SUPER::_selectInstall();
}

sub _selectPendingInstall{
    my ($self) = @_;
    if($self->hasHDBSystems()){
        $self->{'rb_hdb_update'}->SetValue(0) if(defined $self->{'rb_hdb_update'});
        $self->{'rb_hdb_install'}->SetValue(0) if(defined $self->{'rb_hdb_install'});
        $self->enableCockpitHDBInstall(0);
        $self->enableCockpitHDBUpdate(0);
    }
    $self->SUPER::_selectPendingInstall();
}

sub _selectHDBInstall{
    my ($self) = @_;
    $self->{'rb_hdb_install'}->SetValue(1) if(defined $self->{'rb_hdb_install'});
    $self->{'rb_hdb_install'}->SetFocus() if(defined $self->{'rb_hdb_install'});
    $self->{'rb_install'}->SetValue(0);
    $self->{'rb_update'}->SetValue(0)  if(defined $self->{'rb_update'});
    $self->{'rb_pendingInstall'}->SetValue(0) if(defined $self->{'rb_pendingInstall'});

}
sub _selectHDBUpdate{
    my ($self) = @_;
    $self->{'rb_hdb_update'}->SetValue(0)  if(defined $self->{'rb_hdb_update'});;
    $self->{'rb_hdb_install'}->SetFocus();
    $self->{'rb_install'}->SetValue(0);
    $self->{'rb_update'}->SetValue(0)  if(defined $self->{'rb_update'});
    $self->{'rb_pendingInstall'}->SetValue(0)  if(defined $self->{'rb_pendingInstall'});
    $self->OnRBUpdateCockpitHDB();
}

sub hasCockpitOnHDBSystems{
    my $self = shift;
    my @existingHDB = $self->getExistingHanaSystems();
    return grep{$self->getSystemCollection()->hasCockpitStack($_)} @existingHDB;
}

sub hasNoCockpitHDBSystems{
    my $self = shift;
    my @existingHDB = $self->getExistingHanaSystems();
    return grep{!$self->getSystemCollection()->hasCockpitStack($_)} @existingHDB;
}

sub getExistingHanaSystems{
    my $self = shift;
    my $collection = $self->getSystemCollection();
    my @existingHDB = ();
    push(@existingHDB,$collection->getHanaInstallationsWithoutCockpit());
    push(@existingHDB,$collection->getHanaInstallationsWithCockpit());
    return @existingHDB;
}

sub OnRBUpdate{
    my ($self, $evt) = @_;
    $self->enableCockpitHDBInstall(0);
    $self->enableCockpitHDBUpdate(0);
    $self->SUPER::OnRBUpdate($evt);

}

sub OnRBInstall{
    my ($self, $evt) = @_;
    $self->enableCockpitHDBInstall(0);
    $self->enableCockpitHDBUpdate(0);
    $self->SUPER::OnRBInstall($evt);
}

sub OnRBPendingInstall{
    my ($self, $evt) = @_;
    $self->enableCockpitHDBInstall(0);
    $self->enableCockpitHDBUpdate(0);
    $self->SUPER::OnRBPendingInstall($evt);
}

sub addVersion{
    my $self = shift;
    my $sid = $self->getSelectedSID();
    my $collection = $self->getSystemCollection();
    if($collection->getInstalledSystemFlavour($sid) eq $gFlavourPlatform && $collection->hasCockpitStack($sid)){
        my $cockpitVersion = LCM::Utils::CommonUtils::getCockpitProductVersion($collection->getInstalledSystem($sid));;
        $self->addDescriptionStringItem("Version",$cockpitVersion);
    } else {
        $self->SUPER::addVersion();
    }
}

sub addSystemInfo{
    my $self = shift;
    my $sid = $self->getSelectedSID();
    return if(!defined $sid);
    my $collection = $self->getSystemCollection();
    return if($collection->getInstalledSystemFlavour($sid) ne $gFlavourPlatform || !$collection->hasCockpitStack($sid));
     my $sapsys = $collection->getInstalledSystem($sid);
    $self->addDescriptionStringItem("Database Version",$sapsys->GetVersion());
    my $sysInfo = $collection->getInstalledSystemInfo($sid,0);
    my @sysInfoLines = split("\n", $sysInfo);
    for (my $i = 1; $i < @sysInfoLines; $i++) {
        $self->addDescriptionStringItem("",$sysInfoLines[$i]);
    }
}

sub compileDescriptionItems{
    my ($self) = @_;
    $self->clearDescriptionItems();
    $self->addSystemId();
    $self->addInstanceNr();
    $self->addVersion();
    $self->addInstallationPath();
    my $instance = $self->getSAPInstance();
    if(defined $instance){
        $self->addHosts($instance);
        $self->addPlugins($instance);
    }
    $self->addSystemInfo();
    $self->addPendingInfo();
}

sub _initSelectedAction{
    my ($self) = @_;
    $self->SUPER::_initSelectedAction();
    my $app = Wx::wxTheApp;
    if(defined $self->{'rb_hdb_update'} && $self->{'rb_hdb_update'}->GetValue()){
        $self->_setUpdate(1);
    }
    if(defined $self->{'rb_hdb_install'} && $self->{'rb_hdb_install'}->GetValue()){
        $self->_setUpdate(1);
    }
}

sub Process{
    my $self = shift;
    my $returnHash = $self->SUPER::Process(@_);
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getInstconfig();
    if ($returnHash->{errstate}  || !$app->getInstconfig()->setBatchValueOfRequiredParams('SelectedComponents')) {
        $app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
        return {errstate => 1};
    }
    return $returnHash;
}

sub addExecutionFinalizeDialogs{
    my ($self, $wizard) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getInstconfig();
    my $componentManager = $instconfig->getComponentManager ();
    my $xs2Component     = $componentManager->getComponentByKeyName($gKeynameXS2);
    if($self->_isPendingUpdate() && (!defined($xs2Component) || !$xs2Component->isComponentSelected() || $xs2Component->isUpdate())){
        $self->SUPER::addExecutionFinalizeDialogs($wizard);
    } else {
        $wizard->AddDialog (new LCM::Gui::Dialogs::FinalizeCockpitInstallationDialog ($wizard));
    }
}

sub addSummaryExecutionDialogs{
    my ($self, $wizard) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getInstconfig();
    if($instconfig->isCockpitOnPlatformAction()){
        $wizard->AddDialog (new LCM::Gui::Dialogs::Cockpit::CockpitOnPlatformSummaryDialog ($wizard));
    }
    else{
        $self->SUPER::addSummaryExecutionDialogs($wizard);
    }
}
1;
