package LCM::Gui::Dialogs::ConfigurationExecutionDialog;

use strict;

use base qw ( SAPDB::Install::Wizard::Dialog::Base );
use Wx qw (wxEXPAND wxTOP wxALL wxLEFT wxVERTICAL wxALIGN_LEFT wxBOTTOM);
use LCM::Gui::TaskExecutionPlan;
use SAPDB::Install::Window::ExecPlan;
use SDB::Install::Gui::Design;
use SDB::Install::SysVars qw($isWin);
use LCM::ExecutionWarningsObservable;
use LCM::Executors::ExecutionWarningsHandler;
use LCM::Gui::Dialogs::ConfigurationExecutionProgressHandler;

sub new{
    my($self ) = shift->SUPER::new(@_);

    $self->{name} = 'Execute';
    $self->{id} = 'configure';

    my $app = Wx::wxTheApp();
    my $configuration = $app->getInstconfig();
    my $text = $configuration->getProductName();

    $self->{'caption'} = Wx::StaticText->new($self,-1,$text,[0,0],[-1,-1]);
    $self->{'caption'}->SetFont (SDBFONT_DialogTitle) if (!Wx::wxGTK1());
    $self->{'plan'} =  LCM::Gui::TaskExecutionPlan->new($self,-1);

    my $top_sizer = Wx::BoxSizer->new(wxVERTICAL);
    $top_sizer->Add($self->{'caption'},0,wxALIGN_LEFT | wxLEFT | wxTOP , 20);
    $top_sizer->Add($self->{'plan'},1,wxALL | wxEXPAND, 20);
    $self->SetSizer($top_sizer);
    $self->SetAutoLayout(1);
    $self->Layout;
    return $self;
}

sub init{
	my ($self,$config) = @_;
    
    $self->GetWizard()->KillPreviousDialogs();
    $self->{progressLabel} = new Wx::StaticText($self, -1, '');
    $self->GetSizer()->Add( $self->{progressLabel}, 0, Wx::wxEXPAND | Wx::wxLEFT | Wx::wxBOTTOM, 20);

    return {'auto_next' => 1};
}

sub Process{
	my ($self) = @_;
	my $app = Wx::wxTheApp();
	my $configuration = $app->getInstconfig();
	my $action = $configuration->getAction();

	$configuration->dumpConfigFile('hdblcmgui');
	
	my $configurationProgressListener = new LCM::Gui::Dialogs::ConfigurationExecutionProgressHandler ($self->{plan}, $self->{progressLabel});
	my $processTask;

	if($action eq 'configure_internal_network'){
		require LCM::Task::ConfigureInternalNetworkProcessTask;
		$processTask = new LCM::Task::ConfigureInternalNetworkProcessTask($configuration);
	} elsif($action eq 'configure_sld'){
		require LCM::Task::ConfigureSLDProcessTask;
		$processTask = new LCM::Task::ConfigureSLDProcessTask($configuration);
	} elsif($action eq 'add_host_roles'){
		require LCM::Task::AddHostRolesUIProcessTask;
		$processTask = new LCM::Task::AddHostRolesUIProcessTask($configuration);
	} elsif($action eq 'remove_host_roles') {
		require LCM::Task::RemoveHostRolesUIProcessTask;
		$processTask = new LCM::Task::RemoveHostRolesUIProcessTask($configuration);
	} elsif($action eq 'add_hosts') {
		require LCM::Task::AddHostsUIProcessTask;
		$processTask = new LCM::Task::AddHostsUIProcessTask($configuration);
	} elsif($action eq 'remove_hosts') {
		require LCM::Task::RemoveHostsUIProcessTask;
		$processTask = new LCM::Task::RemoveHostsUIProcessTask($configuration);
	} elsif ( !$isWin && (('rename_system' eq $action) || ('register_rename_system' eq $action) || ('continue_rename' eq $action)) ) {
		require LCM::Task::RenameSystemUIProcessTask;
		$processTask = new LCM::Task::RenameSystemUIProcessTask($configuration);
	} elsif ( !$isWin && ($action =~ m/^unregister_(system|instance)$/)) {
		require LCM::Task::UnregisterProcessTask;
		$processTask = new LCM::Task::UnregisterProcessTask($configuration);
	} elsif ('update' eq $action) {
		require LCM::Task::UpdateSystemBootstrapProcessTask;
		$processTask = new LCM::Task::UpdateSystemBootstrapProcessTask($configuration);
	} 
	if (defined $processTask) {
		for my $subtask (@{$processTask->getSubtasks()}){
			my $configurationProgressListener = new LCM::Gui::Dialogs::ConfigurationExecutionProgressHandler ($self->{plan}, $self->{progressLabel});
			$subtask->addListener($configurationProgressListener);
		}
	}

	$app->setExecutor($processTask);
	LCM::ExecutionWarningsObservable->getInstance()->registerListener(LCM::Executors::ExecutionWarningsHandler->new($processTask));

	$configuration->{processTask} = $processTask;
	$self->InitProgress($processTask->getSubtasks());

	my $returnStatus = {};
	$processTask->execute();
	if($processTask->getStatus()->isInErrorState()) {
		my $productName = $configuration->getProductName();
		$app->ShowErrorMsg("$productName failed", $processTask->getErrMsgLst());
		$returnStatus = {'error_state' => 1};
	}

	$app->handleExecutorMsgLst();
	return $returnStatus;
}

sub CallbackRefresh;
*CallbackRefresh = \&Wx::Yield;

sub Destroy{
	my ($self) = @_;
    
	if(defined $self->GetSizer){
		$self->GetSizer->Clear (1);
	}
    
    foreach my $element ('plan', 'caption') {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
	$self->SUPER::Destroy;
}

sub InitProgress($$$$){
	my $self = shift();
	my $application = Wx::wxTheApp();
	my ($tasks) = @_;
	$self->{'plan'}->init($tasks,{'with_progress' => 1});

	$self->GetWizard()->LayoutDlg();
	Wx::Yield ();	
}

sub IncValue ($$){
	my ($self,$value) = @_;
	Wx::Yield ();	
}

sub IncRange ($$){
	my ($self,$value) = @_;
	Wx::Yield ();	
}

sub SetProgress ($$) {
	my ($self,$msg) = @_;
	Wx::Yield ();	
}

sub StepFinished{
    my ($self,$error) = @_;
    
    if ($error){
    	$self->{'plan'}->Next('FINISHED_ERROR');
    }else{
		$self->{'plan'}->SetProgress (100);
		$self->{'plan'}->Next ('FINISHED_SUCCESS');
    }
} 

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;
