#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Installation summary dialog

package LCM::Gui::Dialogs::ConfigurationSummaryDialog;

use base SAPDB::Install::Wizard::Dialog::Base;

use Wx qw (wxVERTICAL wxHORIZONTAL wxEXPAND wxLEFT wxRIGHT wxTOP wxBOTTOM wxALIGN_CENTER);
use Wx::Event qw (EVT_SIZE);
use SDB::Install::Gui::Design;
use SDB::Install::SysVars qw ($isWin);
use LCM::SummaryTreeBuilder;
use strict;

our $is_gtk1 = 0; #Wx::wxGTK1 ();

our $resources = new SAPDB::Install::Resources ();
our $images = $resources->getImages (qw(icon/warning.png));

sub new {
    my ($self) = shift->SUPER::new(@_);
    
    my $sizer = Wx::BoxSizer->new(wxVERTICAL);

    $self->{id} = 'summary';
    $self->{name} = 'View Summary';

    if ($isWin){
        $self->{'tree_ctrl'} = Wx::TreeCtrl->new($self,-1,[-1,-1],[-1,-1]);
    } else{
        $self->Show(1);
        $self->{'tree_ctrl'} = Wx::TreeCtrl->new($self,-1,[-1,-1],[-1,-1]);
        $self->Show(0);
    }

    $self->{'titel_big'} = Wx::StaticText->new($self, -1, "Summary");
    $self->{'titel_big'}->SetFont( SDBFONT_DialogTitle ) if (!$is_gtk1);

    $self->{'warnings_icon'} = Wx::StaticBitmap->new($self, -1, new Wx::Bitmap ($images->{'icon/warning.png'}));
    $self->{'warnings_text'} = Wx::StaticText->new($self, -1, "");
    $self->{'warnings_text'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);

    $self->{'warnings_icon'}->Show(0);
    $self->{'warnings_text'}->Show(0);

     my $handler = sub {
         my ($dialog,$evt) = @_;
         if ($self->{'warnings_text_string'}) {
            $self->{'warnings_text'}->SetLabel($self->{'warnings_text_string'});
            $dialog->{warnings_text}->Wrap (($dialog->GetSizeWH())[0] - 10 - 20 - 20);
         }
        $dialog->Layout();
     };

     EVT_SIZE($self,$handler);

     my $warning_sizer = new Wx::BoxSizer(wxHORIZONTAL);
     $warning_sizer->Add($self->{'warnings_icon'},0,wxLEFT | wxTOP,20);
     $warning_sizer->AddSpacer(10);
     $warning_sizer->Add($self->{'warnings_text'},0, wxEXPAND | wxTOP | wxALIGN_CENTER,20);

    $sizer->Add($warning_sizer,0,wxEXPAND);
    $sizer->Add($self->{'titel_big'},0,wxLEFT | wxTOP | wxBOTTOM,20);
    $sizer->Add($self->{'tree_ctrl'},1,wxEXPAND | wxLEFT | wxRIGHT | wxBOTTOM,20);

    $self->SetSizer($sizer);
    $self->SetAutoLayout(1);
    
    return $self;
}

sub init{
    my ($self) = @_;
    my $app = Wx::wxTheApp ();
    my $instconfig = $app->getInstconfig ();

    $self->GetWizard->{'nbutton'}->SetLabel("&Run");

    if(!$self->_checkConfiguration($app, $instconfig)){
        return { 'errstate' => 1 };
    }

    my $step = $instconfig->getStep ();
	$step = defined $step ? int $step : 0;
    
    my $summaryTree;
    
    if($instconfig->can('createSummaryTree')){
    	$summaryTree = $instconfig->createSummaryTree();
    } else {
    	$summaryTree = LCM::SummaryTreeBuilder::buildSummaryTree($instconfig, undef);
    }

    my $warnings =  [];
    if($instconfig->can('getWarnings')){
        $warnings = $instconfig->getWarnings();
    }

    if (@$warnings){
        $self->{'warnings_text_string'} = join ("\n\n",@$warnings);
        $self->{'warnings_text'}->SetLabel($self->{'warnings_text_string'});
        $self->{'warnings_icon'}->Show(1);
        $self->{'warnings_text'}->Show(1);
    } else {
    	$self->{'warnings_text_string'} = '';
        $self->{'warnings_icon'}->Show(0);
        $self->{'warnings_text'}->Show(0);
    }

    $self->_addTreeNode($summaryTree);

    #root
    $self->{'tree_ctrl'}->ExpandAll();
    $self->Layout();
    return {};
}

sub _addTreeNode {
	my ($self, $summaryNodeRef, $parentTreeNode) = @_;
	
	my $treeControl = $self->{'tree_ctrl'};
	my $currentTreeNode;
	my $currentNodeText = $summaryNodeRef->{"text"};
	if (!defined $parentTreeNode) {
		$currentTreeNode = $treeControl->AddRoot($currentNodeText);		
	} else {
		$currentTreeNode = $treeControl->AppendItem($parentTreeNode, $currentNodeText);
	}
	
	my $childrenRef = $summaryNodeRef->{"children"};
	if (!defined $childrenRef) {
		return;
	}
	if (!$is_gtk1){
		$treeControl->SetItemFont ($currentTreeNode, SDBFONT_BoldText); 
	    $treeControl->SetItemText ($currentTreeNode, $currentNodeText);
	}
	foreach my $childRef (@{ $childrenRef }) {
		$self->_addTreeNode($childRef, $currentTreeNode);
	}
}

sub Process{
    return {};
}

sub Back{
    $_[0]->{'tree_ctrl'}->DeleteAllItems();
    $_[0]->GetWizard->SetInstallMode (0);
    $_[0]->GetWizard ()->EnableNextButton ();
    $_[0]->GetWizard->{'nbutton'}->SetLabel("Next");
    return 1;
}

sub _getInstconfig() {
	my ($self) = @_;
	return Wx::wxTheApp->{instconfig};
}

sub Destroy{
    my ($self) = @_;

    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    foreach my $element (  'tree_ctrl', 'titel_big', ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }

    $self->SUPER::Destroy;
}

sub DESTROY{
    my ($self) = @_;
    print ">>>> destroying $self\n"
        if $SAPDB::Install::DEBUG::DESTRUCT;
}

sub _checkConfiguration {
    my ($self, $application, $configuration) = @_;
    my $msg = $application->getMsgLst()->addMessage("Checking entire configuration (dialog $self->{name})");
    my $saveContext = $configuration->setMsgLstContext([$msg->getSubMsgLst(), undef]);

    $application->resetError();
    $configuration->resetError();
    $msg->setEndTag('Configuration Check');

    my $isSuccess = $configuration->CheckParams(1);
    $configuration->setMsgLstContext($saveContext);
    return $isSuccess ? 1 : undef;
}

1;
