package LCM::Gui::Dialogs::CredentialsDialog;

use base qw(SDB::Install::Gui::Dialogs::GenericParameter);
use strict;

sub new{
    my($self) = shift->SUPER::new(@_);
    
    $self->{id} = 'Password';
    $self->{label_text} = "Enter System Administrator Credentials";
    $self->{name} = 'Enter Credentials';
    
    return $self;
}

sub getParamKeys{
    return ['Password', 'RootPassword'];
}

sub Process{
	my $self = shift;
	my $returnValue = $self->SUPER::Process(@_);

	my $app = Wx::wxTheApp();
   	my $instconfig = $app->{'instconfig'};
	if (defined $returnValue && !$instconfig->getErrMsgLst()->isEmpty()) {
		my $productName = $instconfig->getProductName();
		$app->ShowErrorMsg("$productName failed", $instconfig->getErrMsgLst());
	    $returnValue = {'errstate' => 1};
	}
	return $returnValue;
}

1;