package LCM::Gui::Dialogs::FinalizationStepsFactory;

use LCM::Component;
use LCM::Configuration::GenericStackAny qw (UNINSTALL_ACTION);
use LCM::ComponentStepWrapper;
use LCM::Executors::ExecutionStep;
use LCM::ConfigurationFinalizationStep;

use strict;

sub new{
	my ($class, $app) = @_;
	my $self = {};
	bless $self, $class;
	
	$self->{app} = $app;
	
	return $self;
}

sub createFinalizationSteps{
	my ($self, $isFinalizationWithComponentSteps,$isConfigurationStep) = @_;
	my $finalizationSteps;
	
	if ($isFinalizationWithComponentSteps){
		$finalizationSteps = $self->_createComponentSteps();
	} elsif($isConfigurationStep){
		$finalizationSteps = $self->createConfigurationFinalizationSteps();
	} else {	
		$finalizationSteps = $self->_createExecutionSteps();		
	}
	
	return $finalizationSteps;
}

sub _createComponentSteps{
	my ($self) = @_;
	my $selectedComponents = $self->_getSelectedComponents();
	my $componentWrappers = [];
	
	for my $component (@$selectedComponents) {
		my $componnetWrapper = new LCM::ComponentStepWrapper( $component );
		push @$componentWrappers, $componnetWrapper;
	}
	
	return $componentWrappers;
}

sub _createExecutionSteps{
	my ($self) = @_;
	my $app = $self->{app};
	my $executor = $app->{executor};		
	my $executionSteps = [];
	my $executorRef = ref $executor;
  
	if ($executorRef eq "LCM::Task::Hosts::AddHosts::AddRemoteHostsTask"){
		my $executionStep = new LCM::Executors::ExecutionStep();
	    my $statusArray = $executor->getStatusArray();
	    my $executorStatus = $statusArray->[0] if defined $statusArray;
		my $label = $self->_createAdditionalHostsLabel();
		my $logLocation = $executor->getLogLocation();

		SetExecutionStepDetails($executionStep, $logLocation, $label, $executorStatus,$executor->getWarnings());
		push @$executionSteps, $executionStep;
	} elsif ($executorRef eq "LCM::Task::Hosts::AddHosts::AddHostsWrapperTask"){
		my $executionStep = new LCM::Executors::ExecutionStep();
	    my $statusArray = $executor->getStatusArray();
	    my $executorStatus = $statusArray->[0] if defined $statusArray;
		my ($localHostExecutor, $additionalHostsExecutor) = $executor->getWrappedTasks();		
		my $localExecutorLogLocation = $localHostExecutor->getLogLocation();

		SetExecutionStepDetails($executionStep, $localExecutorLogLocation, "Add Local Host (hdbaddhost)", $executorStatus,$executor->getWarnings());
		push @$executionSteps, $executionStep;

		if (defined $additionalHostsExecutor){
			my $label = $self->_createAdditionalHostsLabel();
			my $additionalHostsExecutionStep = new LCM::Executors::ExecutionStep();
			my $additionalHostsExecutorStatus = (defined $statusArray) ? $statusArray->[1] : undef;
			my $additionalExecutorLogLocation = $additionalHostsExecutor->getLogLocation(); 

			SetExecutionStepDetails($additionalHostsExecutionStep, $additionalExecutorLogLocation, $label, $additionalHostsExecutorStatus,$executor->getWarnings());		
			push @$executionSteps, $additionalHostsExecutionStep;
		}
	} else{
	   $executionSteps = $executor->getExecutionSteps();
    }
	
	return $executionSteps;
}

sub SetExecutionStepDetails{
	my ($executionStep, $logLocation, $name, $status, $warnings) = @_;
	
	$executionStep->setName($name);
	$executionStep->setStatus($status) if defined $status;
	$executionStep->setWarnings($warnings);
	
	if (defined $logLocation){
		$executionStep->setLogLocation($logLocation);
	}
}

sub _getSelectedComponents {
	my ( $self ) = @_;
	my $app               = $self->{app};
	my $instconfig        = $app->getInstconfig();
	my $component_manager = $instconfig->{componentManager};
	
    if ($instconfig->getAction() eq UNINSTALL_ACTION) {
       $component_manager = $component_manager->getSystemComponentManager();
    } 	
    
    return $component_manager->getSelectedComponents();
}

sub _createAdditionalHostsLabel{
	my ($self) = @_;
	my $app = $self->{app};
	my $instconfig = $app->{instconfig};
	my $label;

	if ($instconfig->isOneAdditionalRemoteHostForAdding()){
		$label = "Add Host (hdbmodify)";
	} else {
		$label = "Add Hosts (hdbmodify)";
	}

	return $label;
}

sub createConfigurationFinalizationSteps {		
	my ($self) = @_;		
	my $instconfig = $self->{app}->{instconfig};		
	my $executionManagers = $instconfig->{processTask};
	my $finalizationSteps = [];		
	if (defined $executionManagers){		
		for my $executionManager (@{$executionManagers}){
			push @{$finalizationSteps}, new LCM::ConfigurationFinalizationStep($executionManager);		
		}		
	}		
	return $finalizationSteps;		
}

1;
