package LCM::Gui::Dialogs::GenericCredentialsDialog;
use parent qw(SAPDB::Install::Wizard::Dialog::Base);
use LCM::Gui::DialogUtilities qw(GetAppConfig);
use strict;

use SDB::Install::Gui::Design qw(SDBFONT_DialogTitle);
use Wx qw(wxVERTICAL wxLEFT wxEXPAND wxALIGN_CENTER_VERTICAL wxBOTTOM wxALL wxTE_PASSWORD);

use constant CONFIRM_LABEL => 'ConfirmationLabel';
use constant CONFIRM_CONTROL => 'ConfirmationControl';
use constant CONTROL => 'Control';
use constant LABEL => 'Label';

sub new{
    my $self = shift->SUPER::new(@_);
    return $self;
}

sub init{
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $config = $app->{instconfig};
    my $mainSizer = Wx::BoxSizer->new(wxVERTICAL);
    my $dialogTitle = Wx::StaticText->new($self, -1, $self->{label_text});
    my $gridSizer = Wx::FlexGridSizer->new(6, 2, 5, 15);
    $config->setBatchValueOfRequiredParams($self->getParamIds()->[-1]);

    $mainSizer->AddSpacer (20);
    $dialogTitle->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
    $mainSizer->Add($dialogTitle,0, wxLEFT , 20 );
    $mainSizer->Add ($gridSizer,0, wxEXPAND | (wxALL) & (~wxBOTTOM), 20);

    $self->createControls($gridSizer,$config);

    if (!keys %{$self->{_uiControls}}) {
        return {'auto_next' => 1};
    }

    $gridSizer->AddGrowableCol(1);
    $self->SetSizerAndFit($mainSizer);
    $self->SetAutoLayout(1);
    $self->Layout();
    $self->Show(1);

    return {}; 
}

sub getParamIds{
    ...
}

sub createControls{
    my ($self,$gridSizer,$config) = @_;
    my $paramIds = $self->getParamIds($config);
    for (@$paramIds) {
        $self->_addParameterControl($_, $gridSizer, $config);
    }
}

sub BackInit{
    my ($self) = @_;
    if (!keys %{$self->{_uiControls}}) {
        return {'auto_back' => 1};
    }
    return {};
}

sub Process {
    my ($self,) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

    $instconfig->resetError ();
    my $paramIds = $self->getParamIds($instconfig);
    for (@$paramIds) {
        return undef if (!$self->_setParameter($app, $_, $instconfig));
    }
    return {};
}

sub _shouldConfirmPassword {
    my ($self, $paramId, $config) = @_;
    return $config->getType($paramId) eq 'initial_passwd';
}

sub _addParameterControl {
    my ($self, $paramId, $gridSizer, $config) = @_;

    # Nothing to create if parameter is nonexistent or skipped/hidden
    return if (!exists $config->{params}->{$paramId});
    return if ($config->isSkipped($paramId) || $config->isHidden($paramId) || !$config->isInteractive($paramId));

    my $paramStr    = $config->getString($paramId);
    my $paramType   = $config->getType($paramId);
    my $isMandatory = $config->isMandatory($paramId);
    my $paramValue  = $config->getValue($paramId) || $config->getDefault($paramId);
    $paramValue = '' if (!defined $paramValue);

    my $label = SDB::Install::Gui::Control::Label->new($self, -1, $paramStr, $isMandatory);
    my $control = $self->_createUserInputControl($paramType, $paramValue);
    $gridSizer->Add($label, 0, wxALIGN_CENTER_VERTICAL);
    $gridSizer->Add($control, 1, wxEXPAND);
    $self->{_uiControls}->{"_${paramId}".LABEL} = $label;
    $self->{_uiControls}->{"_${paramId}".CONTROL} = $control;

    $self->_createPasswordConfirmationControlIfNeeded($paramId, $gridSizer, $config);
}

sub _createPasswordConfirmationControlIfNeeded {
    my ($self, $paramId, $gridSizer, $config) = @_;
    return if (!$self->_shouldConfirmPassword($paramId,$config));

    my $paramStr    = $config->getString($paramId);
    my $isMandatory = $config->isMandatory($paramId);
    my $paramValue  = $config->getValue($paramId) || $config->getDefault($paramId);

    my $confirmationLabel = SDB::Install::Gui::Control::Label->new( $self, -1, "$paramStr Confirmation", $isMandatory);
    my $confirmationControl = new Wx::TextCtrl ($self, -1, $paramValue,[-1,-1], [-1,-1],wxTE_PASSWORD);
    $gridSizer->Add($confirmationLabel,0, wxALIGN_CENTER_VERTICAL);
    $gridSizer->Add($confirmationControl, 1, wxEXPAND  );
    $self->{_uiControls}->{"_${paramId}".CONFIRM_LABEL} = $confirmationLabel;
    $self->{_uiControls}->{"_${paramId}".CONFIRM_CONTROL} = $confirmationControl;
}

sub _setParameter {
    my ($self, $app, $paramId, $config) = @_;
    my $uiControl = $self->getParameterControl($paramId);
    my $paramStr = $config->getString($paramId);

    return 1 if (!defined $uiControl);

    my $controlValue = $uiControl->GetValue();
    if (!$controlValue && $config->isMandatory($paramId)) {
        $app->ShowErrorMsg("$paramStr is empty");
        $uiControl->SetFocus();
        return undef;
    }

    if($self->_shouldConfirmPassword($paramId,$config)) {
        my $confirmationControl = $self->getParameterControl($paramId,1);
        my $confirmationValue = $confirmationControl->GetValue();
        if($controlValue ne $confirmationValue) {
            $app->ShowErrorMsg("Password confirmation for '$paramId' doesn't match");
            $uiControl->SetFocus();
            return undef;
        }
    }

    if (!$config->setValue($paramId, $controlValue)) {
        $app->ShowErrorMsg("Invalid $paramStr value", $config->getErrMsgLst());
        $uiControl->SetFocus();
        return undef;
    }
    return 1;
}

sub _createUserInputControl {
    my ($self, $type, $value) = @_;
    if($type eq 'path'){
        return new SAPDB::Install::Control::PathCtrl($self, -1, $value, [-1,-1], [-1,-1]);
    } elsif ($type =~ /passwd/) {
        return new Wx::TextCtrl($self, -1, $value,[-1,-1], [-1,-1], wxTE_PASSWORD);
    } else {
        return new Wx::TextCtrl($self, -1, $value,[-1,-1], [-1,-1]);
    }
}

sub Back{
    my ($self) = @_;
    $self->Reset();
}

sub Reset{
    my ($self) = @_;
    
    if(defined $self->GetSizer()){
        $self->GetSizer->Clear (1);
    }
    delete($self->{_uiControls});
    $self->SUPER::Reset();
}

sub Destroy{
    my ($self) = @_;
    $self->Reset();
    $self->SUPER::Destroy;
}

sub DESTROY{
    my ($self) = @_;
    print ">>>>> destroying $self\n"
        if $SAPDB::Install::DEBUG::DESTRUCT;
}

sub getParameterControl{
    my($self,$paramId,$isConfirmControl) = @_;
    return !$isConfirmControl ? $self->{_uiControls}->{"_${paramId}".CONTROL} : $self->{_uiControls}->{"_${paramId}".CONFIRM_CONTROL};
}
1;