#!/usr/bin/perl
package LCM::Gui::Dialogs::HostsExecutionDialog;

use Wx qw (wxEXPAND wxTOP wxALL wxLEFT wxVERTICAL wxALIGN_LEFT wxBOTTOM);

use base qw (SAPDB::Install::Wizard::Dialog::Base);
use SAPDB::Install::Window::ExecPlan;
use SDB::Install::Gui::Design;
use LCM::Gui::Dialogs::AddHosts::AddHostsProgressHandler;

use strict;

sub new {
    my($self ) = shift->SUPER::new(@_);

    $self->{name} = 'Execute';
    $self->{id} = 'configure';
    
    my $app = Wx::wxTheApp();
    my $instconfig = $app->{'instconfig'};
    my $text = $instconfig->getProductName();

    $self->{'caption'} = Wx::StaticText->new($self,-1,$text,[0,0],[-1,-1]);
    $self->{'caption'}->SetFont (SDBFONT_DialogTitle) if (!Wx::wxGTK1());
    
    my $top_sizer = Wx::BoxSizer->new(wxVERTICAL);
    $self->{'plan'} = SAPDB::Install::Window::ExecPlan->new($self,-1);    
    $top_sizer->Add($self->{'caption'},0,wxALIGN_LEFT | wxLEFT | wxTOP , 20);
    $top_sizer->Add($self->{'plan'},1,wxALL | wxEXPAND, 20);
    $self->SetSizer($top_sizer);
    $self->SetAutoLayout(1);
    $self->Layout;
    return $self;
}

sub init{
    my ($self,) = @_;

    my $app = Wx::wxTheApp();
    my $config = $app->{'instconfig'};

    $config->ResetError();
    $self->GetWizard()->KillPreviousDialogs();
    $self->{progressLabel} = new Wx::StaticText($self, -1, '');
    $self->GetSizer()->Add( $self->{progressLabel}, 0, Wx::wxEXPAND | Wx::wxLEFT | Wx::wxBOTTOM, 20);
}

sub Process {
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->{'instconfig'};

    $instconfig->dumpConfigFile('hdblcmgui');

    my $configProgressHandler = $self->_getConfigProgressHandler();
    my $updHostProgressHandler = new LCM::Gui::Dialogs::UpdateHosts::ProgressHandler($self->{plan},$self->{progressLabel});
    $updHostProgressHandler->setParentProgressHandler($configProgressHandler);

    my $executionManager = $app->{executor};
    $executionManager->setProgressHandler($configProgressHandler);
    $executionManager->setUpdateHostProgressHandler($updHostProgressHandler);

    $self->_createProgressBars();      
    my $rc = $executionManager->execute();

    my $returnStatus = {};
    if (!$rc) {
        my $productName = $instconfig->getProductName();
        $app->ShowErrorMsg("$productName failed", $executionManager->getErrMsgLst());
        $returnStatus = {'error_state' => 1};
    }

    $app->handleExecutorMsgLst();
    return $returnStatus;
}

sub CallbackRefresh;
*CallbackRefresh = \&Wx::Yield;

sub Destroy{
    my ($self) = @_;
    
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }
    
    foreach my $element ('plan', 'caption') {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    $self->SUPER::Destroy;
}

sub InitProgress($$$$){
    my ($self,$steps,$value,$names) = @_;
    my @steps;
    foreach my $name (@$names){
        push @steps, {'Label' => $name, 'State' => 'PENDING'};
    }
    $self->{'plan'}->init(\@steps,{'with_progress' => 1});
    $self->GetWizard()->LayoutDlg();
    Wx::Yield ();
}

sub IncValue ($$){
    my ($self,$value) = @_;
    Wx::Yield ();   
}

sub IncRange ($$){
    my ($self,$value) = @_;
    Wx::Yield ();   
}

sub SetProgress ($$) {
    my ($self,$msg) = @_;
    Wx::Yield ();   
}

sub StepFinished{
    my ($self,$error) = @_;
    Wx::Yield ();
}

sub DESTROY{
    my ($self) = @_;
    print ">>>>> destroying $self\n"
        if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;
