package LCM::Gui::Dialogs::HostsPanelButtonListener;

use base qw ( Exporter );
our @EXPORT = qw ( OnAssignRoles OnAddHost OnEditHost OnRemoveHost );

use LCM::HostsUtility qw ( IsHostPartOfSystem );
use LCM::Gui::Dialogs::HostsPanelTableListener qw (  GetListItem UpdateListItem UpdateListItemAfterEdit InsertListItem );
use Wx qw ( wxLIST_NEXT_ALL wxLIST_STATE_SELECTED );

sub OnAssignRoles {
	my ($window) = @_;

	my $itemIndex = $window->{selectedItemIndex};
	my $isLocalHost = IsHostPartOfSystem() ? 0 : ( $itemIndex == 0 );

	my $host = GetListItem( $window, $itemIndex );

	require LCM::Gui::Dialogs::AdditionalRolesDialog;
	my $dlg = new LCM::Gui::Dialogs::AdditionalRolesDialog($window, $host->getHost());
	my $primaryRole = (split(',', $host->getRole()))[0];
	$dlg->setPrimaryHostRole($primaryRole);
	$dlg->handleSelectedHostRolesCB( $host, $isLocalHost );

	my $retCode = $dlg->ShowModal();
	$dlg->Destroy();
	if ( $retCode != $dlg->GetAffirmativeId() ) {
		return;
	}
	
	$host->{role} = $dlg->getCSVRoles();
	my $checkListValidity = 0;
	UpdateListItem( $window, $itemIndex, $host, $checkListValidity );		
}

sub OnAddHost {
	my ($window) = @_;

	my $dlg = new LCM::Gui::Dialogs::AdditionalHostPropsDialog($window);
	my $retCode = $dlg->ShowModal ();
	$dlg->Destroy();
	if ($retCode != $dlg->GetAffirmativeId()) {
		return;
	}

	my $hostObj = $dlg->GetHost();
	InsertListItem( $window, $hostObj);
}

sub OnEditHost {
	my ($window) = @_;

	my $listCtrl = $window->{Controls}->{'HostsList'};
	my $itemIndex = $listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	my $host = GetListItem( $window, $itemIndex );

	my $dlg = new LCM::Gui::Dialogs::AdditionalHostPropsDialog($window);
	$dlg->SetHost($host);

	my $retCode = $dlg->ShowModal ();
	$dlg->Destroy();
	if ($retCode != $dlg->GetAffirmativeId()) {
		return;
	}

	$host = $dlg->GetHost();
	UpdateListItemAfterEdit( $window, $itemIndex, $host);
}

sub OnRemoveHost {
	my ($window) = @_;

	my $hostListCtrl = $window->{Controls}->{HostsList};
	my $itemIndex = -1;
	while(1){
		$itemIndex = $hostListCtrl->GetNextItem($itemIndex, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
		last if $itemIndex == -1;
		$hostListCtrl->DeleteItem($itemIndex);
	}
	$window->{Controls}->{'removeButton'}->Enable(0);
	$window->{Controls}->{'editButton'}->Enable(0);
	$window->{Controls}->{'editRolesBtn'}->Enable(0);
}

1;