package LCM::Gui::Dialogs::MasterPasswordDialog;

use strict;
use SDB::Install::Gui::Design;
use parent qw(SAPDB::Install::Wizard::Dialog::Base);
use Wx qw(wxVERTICAL wxLEFT wxEXPAND wxALIGN_CENTER_VERTICAL wxBOTTOM wxALL wxTE_PASSWORD);

sub new{
    my($self) = shift->SUPER::new(@_);

    $self->{id} = 'MasterPasswordProperties';
    $self->{label_text} = "Specify Master Password";
    $self->{name} = "Define Master Password";

    return $self;
}

sub init{
    my ($self,$config) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->{instconfig};
    my $mainSizer = Wx::BoxSizer->new(wxVERTICAL);
    my $dialogTitle = Wx::StaticText->new($self, -1, $self->{label_text});
    my $gridSizer = Wx::FlexGridSizer->new(6, 2, 5, 15);

    $mainSizer->AddSpacer(20);
    $dialogTitle->SetFont(SDBFONT_DialogTitle) if (!Wx::wxGTK1());
    $mainSizer->Add($dialogTitle,0, wxLEFT , 20 );
    $mainSizer->Add ($gridSizer,0, wxEXPAND | (wxALL) & (~wxBOTTOM), 20);
    $self->_addPasswordConfirmationControls('MasterPassword', $gridSizer, $instconfig);

    $gridSizer->AddGrowableCol( 1 );
    $self->SetSizerAndFit($mainSizer);
    $self->SetAutoLayout(1);
    $self->Layout();
    $self->Show(1);

    return {};
}

sub _addPasswordConfirmationControls {
    my ($self, $parameterName, $gridSizer, $instconfig) = @_;

    # Nothing to create if parameter is skipped or not existent
    return unless(exists($instconfig->{params}->{$parameterName}));
    return if($instconfig->isSkipped($parameterName));

    my $parameter = $instconfig->{params}->{$parameterName};
    my $isMandatory = $parameter->{mandatory} ? 1 : 0;
    my $parameterValue = (defined $parameter->{value} ? $parameter->{value} : $instconfig->getDefault($parameterName));
    my $parameterString = $parameter->{str};
    $parameterValue = '' if(!defined($parameterValue));

    my $label = SDB::Install::Gui::Control::Label->new( $self, -1, $parameterString, $isMandatory);
    my $control = new Wx::TextCtrl ($self, -1, $parameterValue,[-1,-1], [-1,-1],wxTE_PASSWORD);
    $gridSizer->Add($label,0, wxALIGN_CENTER_VERTICAL);
    $gridSizer->Add($control, 1, wxEXPAND  );
    $self->{_uiControls}->{"_${parameterName}Label"} = $label;
    $self->{_uiControls}->{"_${parameterName}Control"} = $control;

    if($self->_shouldConfirmPassword($parameterName, $instconfig)){
        my $confirmationLabel = SDB::Install::Gui::Control::Label->new( $self, -1, "$parameterString Confirmation", $isMandatory);
        my $confirmationControl = new Wx::TextCtrl ($self, -1, $parameterValue,[-1,-1], [-1,-1],wxTE_PASSWORD);
        $gridSizer->Add($confirmationLabel,0, wxALIGN_CENTER_VERTICAL);
        $gridSizer->Add($confirmationControl, 1, wxEXPAND  );
        $self->{_uiControls}->{"_${parameterName}ConfirmationLabel"} = $confirmationLabel;
        $self->{_uiControls}->{"_${parameterName}ConfirmationControl"} = $confirmationControl;
    }
}

sub _shouldConfirmPassword {
    my ($self, $parameterName, $instconfig) = @_;
    return $instconfig->getType($parameterName) eq 'initial_passwd';
}

sub Process {
    my ($self) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

    $instconfig->resetError ();
    if(!$self->_setMasterPassword($app, $instconfig)){
        return undef;
    }
    $self->GetWizard()->RefreshSkippableDialogs();
    return {};
}

sub _setMasterPassword {
    my ($self, $app, $instconfig) = @_;
    my $passwordControl = $self->{_uiControls}->{_MasterPasswordControl};
    my $shouldConfirmPassword = $self->_shouldConfirmPassword('MasterPassword', $instconfig);
    my $passwordConfirmationControl = $self->{_uiControls}->{_MasterPasswordConfirmationControl};

    # Nothing to do if controls do not exist
    return 1 unless(defined($passwordControl) && (! $shouldConfirmPassword || defined($passwordConfirmationControl)));

    my $passwordValue = $passwordControl->GetValue();

    if(! $passwordValue) {
        $app->ShowErrorMsg( "Master Password is empty" );
        $passwordControl->SetFocus();
        return undef;
    }
    if(! $instconfig->setValue('MasterPassword', $passwordValue)) {
        $app->ShowErrorMsg( "Master Password value", $instconfig->getErrMsgLst() );
        $passwordControl->SetFocus();
        return undef;
    }
    if($shouldConfirmPassword){
        my $passwordConfirmationValue = $passwordConfirmationControl->GetValue();
        if($passwordValue ne $passwordConfirmationValue) {
            $app->ShowErrorMsg("Password confirmation doesn't match");
            $passwordControl->SetFocus();
            return undef;
        }
    }
    return 1;
}

sub Back{
    my ($self) = @_;
    $self->Reset();
}

sub Reset{
    my ($self) = @_;

    if(defined $self->GetSizer()){
        $self->GetSizer->Clear (1);
    }
    delete($self->{_uiControls});
    $self->SUPER::Reset();
}

sub Destroy{
    my ($self) = @_;
    $self->Reset();
    $self->SUPER::Destroy;
}

sub DESTROY{
    my ($self) = @_;
    print ">>>>> destroying $self\n" if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;