package LCM::Gui::Dialogs::RemoveHosts::PasswordsPropertiesDialog;

use strict;

use base qw(SDB::Install::Gui::Dialogs::GenericParameter);

sub new{
    my($self) = shift->SUPER::new(@_);
    
    $self->{id}         = 'RemoveHostPasswords';
    $self->{label_text} = 'Remove Hosts Passwords Properties';
    $self->{name}       = 'Enter Hosts Password';
    
    return $self;
}

sub init {
    my ($self, $config) = @_;
    my $result = $self->SUPER::init($config);
    
    my $rootUserLabel = $self->{dynctrl}->{RootUser_label};    
    if ($result && $rootUserLabel) {
        $rootUserLabel->SetRequired(1);
    }
    return $result;    
}

sub getParamKeys{
    my ($self) = @_;
    my $configuration = Wx::wxTheApp()->getInstconfig();
    
    if($configuration->isUseSAPHostagent()){
    	return ['HostagentPassword'] 
    }
#   Ugly hack - GenericParameter does not show skipped parameters, so this way we show the password
#	and if key authorization is possible RemoveHostsConfiguration's checkRootUser will skip
#	the root password
	my $isSkippedRootUser = $configuration->isSkipped('RootUser');
    $configuration->setSkip('RootPassword', $isSkippedRootUser);
    $configuration->setMandatory('RootPassword', 0);
    
    return ['RootUser', 'RootPassword'];
}

sub Process {
	my ($self,) = @_;
    my $app = Wx::wxTheApp();
    my $config = $app->getInstconfig();
    
    if($config->isUseSAPHostagent()){
    	return $self->_processSHA($config, $app);		
    }
    return $self->_processSSH($config, $app);
}

sub _processSHA {
	my ($self, $config, $app) = @_;
	my $shaPasswordCtrl = $self->{dynctrl}->{HostagentPassword_ctrl};
	my $shaPasswordInput = $shaPasswordCtrl->GetValue();
	
	if ( !$config->setValue('HostagentPassword', $shaPasswordInput) ){
		$app->ShowErrorMsg ('Configuration error', $config->getErrMsgLst());
		$shaPasswordCtrl->SetFocus();
		return undef;
	}
    return {};
}

sub _processSSH {
	my ($self, $config, $app) = @_;
	my ($rootUser, $rootPassword) = $self->_getUserInput($config);
    
    if ( !$config->setRootUser($rootUser) || ($self->_isRootPasswordNeeded($config) && !$config->setRootPassword( $rootPassword)) ) {
        my $rootUserCtrl = $self->{dynctrl}->{RootUser_ctrl};
        $app->ShowErrorMsg ('Configuration error', $config->getErrMsgLst());
        $rootUserCtrl->SetFocus();
        return undef;
    }
    return {};
}

sub _isRootPasswordNeeded {
	my ($self, $config) = @_;
	my $rootPasswordParam = $config->{params}->{RootPassword};
	return $rootPasswordParam->{skip} ? 0 : 1;
}

sub _getUserInput  {
	my ($self,$config) = @_;
	
	my $rootUserCtrl = $self->{dynctrl}->{RootUser_ctrl};
    my $rootUser = $rootUserCtrl->GetValue();
    
     my $rootPassword = undef;
    if($self->_isRootPasswordNeeded($config)){
	    my $rootPasswordCtrl = $self->{dynctrl}->{RootPassword_ctrl};
	    $rootPassword = $rootPasswordCtrl->GetValue();
    }
    return ($rootUser, $rootPassword);
}

1; 
