package LCM::Gui::Dialogs::RemoveHosts::SelectRemoveHostsDialog;

use strict;
use Wx qw( wxVERTICAL wxLEFT wxEXPAND wxALL wxGROW );
use Wx::Event qw (EVT_CHECKBOX);

use base qw (SAPDB::Install::Wizard::Dialog::Base);
use LCM::Gui::Dialogs::RemoveHosts::RemoveHostsPanel;
use SDB::Install::Globals qw (getHumanReadableRolesString);
use SDB::Install::System qw (isSidadmin);
use LCM::Gui::Dialogs::UiComponentsFactory;

sub new{
    my($self) = shift->SUPER::new(@_);
    
    my $is_gtk1 = Wx::wxGTK1 ();
    $self->{id} = 'RemoveHostsParams';
    $self->{name} = "Select Hosts";
    
    my $outersizer = new Wx::BoxSizer (wxVERTICAL);
    $self->SetSizer($outersizer);
    
    my $sizer = new Wx::BoxSizer (wxVERTICAL);
    $self->{'sizer_inner'} = $sizer;
    $outersizer->Add($sizer, 1, wxALL | wxEXPAND | wxGROW, 20);

    my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
    my $title = CreateTitle($self, "Remove Hosts from $flavourProductName System", $is_gtk1);
    $sizer->Add($title, 0);
    $sizer->AddSpacer(20);
    
    my $hostsPanel = LCM::Gui::Dialogs::RemoveHosts::RemoveHostsPanel->new($self);
    my $removeHostsPanel = $hostsPanel->addNewHostPanel( wxVERTICAL, 0, wxEXPAND, 10, wxEXPAND | wxGROW);

    $sizer->Add($removeHostsPanel, 1, wxLEFT | wxGROW, 22);
    $self->{'remove_hosts_panel'} = $removeHostsPanel;
    $sizer->AddSpacer(20);
    
    my $keepUserCheckBox = new Wx::CheckBox($self, 0, "");
    $self->{'keepUserCheckBox'} = $keepUserCheckBox;
    $sizer->Add($keepUserCheckBox);
    EVT_CHECKBOX( $self, $self->{keepUserCheckBox}->GetId(), \&_onKeepUserCheckBox );
    
    my $keepHomeDirCheckBox = new Wx::CheckBox($self, 0, "");
    $self->{'keepHomeDirCheckBox'} = $keepHomeDirCheckBox;
    $sizer->Add($keepHomeDirCheckBox);
    $sizer->AddSpacer(20);
    
    $self->SetAutoLayout (1);
    return $self;
}

sub init {
    my ($self,) = @_;
    
    if ($self->{isInitialized}) {
        return {};
    }

    my $app = Wx::wxTheApp();
    my $config = _getConfig();
    $config->ResetError();

    if(!$config->setBatchValueOfRequiredParams('SID')){
        $app->ShowErrorMsg('Configuration error', $config->getErrMsgLst());
        return undef;
    }
    
    if ( !$self->_fillCheckBoxListWithSystemHosts() ) {
    	$config->PushError("Can not fill list of hosts!");
        $app->ShowErrorMsg ('Configuration error', $config->getErrMsgLst());
        return undef;
    }
    
    $self->_setCheckBoxLabels();
    
    $self->{isInitialized} = 1; 
    return {};
}

sub _fillCheckBoxListWithSystemHosts {
	my ($self,) = @_;

    my $instances = _getNewDBInstances();
    if (!defined $instances or !defined $instances->[0]){
        return undef;
    }

    my $items = $self->_createItems($instances);
    my $hostsList = $self->{Controls}->{'HostsList'};
    $hostsList->InsertItems($items, 0);
    return 1;
}

sub _createItems {
    my ($self, $instances) = @_;

    my @items = ();
    my $instance = $instances->[0];
    # if executed as sidadm hide the local hosts (show only the remote hosts)
    my $allHosts = isSidadmin() ? $instance->get_hosts() : $instance->get_allhosts();
    my $hostRole;
    
    for my $host(@$allHosts) {
    	$hostRole = $self->_getHostsRoles($host);
    	push (@items, "$host - $hostRole");
    }
    
    return \@items;
}

sub _getHostsRoles {
	my ($self, $host) = @_;
	my $config = _getConfig();
	my $instance = $config->getOwnInstance();
	my $hostRolesInfo = $instance->getHostRolesInfo();
	my @hostRoles = split('\s', $hostRolesInfo->{$host});
	my $humanReadableHostRoles = getHumanReadableRolesString(@hostRoles);
	return $humanReadableHostRoles;
}

sub _getNewDBInstances {
	my $sapSystem = _getOwnSapSystem();
    if (!defined $sapSystem) {
        return undef;
    }
    return $sapSystem->getNewDBInstances ();
}

sub _getOwnSapSystem {
    my $installer = new LCM::Installer ();
    return $installer->getOwnSapSystem ();
}

sub _setCheckBoxLabels {
	my ($self, ) = @_;
	my $config = _getConfig();
	
	my $sidadm = $config->getSysAdminUserName($config->getSID());
	$config->{params}->{KeepUser}->{str} .= " $sidadm";
	
	$self->{'keepUserCheckBox'}->SetLabel($config->{params}->{KeepUser}->{str});
    $self->{'keepHomeDirCheckBox'}->SetLabel($config->{params}->{KeepUserHomeDir}->{str});
}

sub Process{
    my ($self, ) = @_;
    
    my $config = _getConfig();
    my $removeHosts = $self->_getSelectedHosts();
    my $app = Wx::wxTheApp();
    
    $config->ResetError();
    
    if($removeHosts eq '') {
    	$config->PushError("You must select at least one host to proceed!");
        $app->ShowErrorMsg ('Configuration error', $config->getErrMsgLst());
        return undef;
    }
    
    if ( !$config->setValue('RemoveHosts', $removeHosts) ) {
        $app->ShowErrorMsg ('Configuration error', $config->getErrMsgLst());
        return undef;
    }
    $self->_setUserInputValues($removeHosts);
    
    $self->_refreshSkippableDialogs();
    return {};
}

sub _refreshSkippableDialogs {
	my ($self) = @_;
	my $config = _getConfig();
	my $isRootUserSkiped = $config->{params}->{RootUser}->{skip};
    my $isRootPasswordSkiped = $config->{params}->{RootPassword}->{skip};
    my $isShaPasswordSkiped = $config->{params}->{HostagentPassword}->{skip};

	my $wizard = $self->GetWizard ();
	my $skipPageFlag = $isRootUserSkiped && $isRootPasswordSkiped && $isShaPasswordSkiped;

    $wizard->SkipDialog ( 'RemoveHostPasswords', $skipPageFlag );
}

sub _getSelectedHosts {
	my ($self) = @_;

	my $hostsList = $self->{Controls}->{'HostsList'};
    my $itemsNumber = $hostsList->GetCount();

    my $itemValue;
    my @removeHosts = ();

    for (0 .. ($itemsNumber-1)) {
        if ($hostsList->IsChecked($_)) {
           $itemValue = $hostsList->GetString($_);
           $itemValue = $self->_clearValue($itemValue);
           push (@removeHosts, $itemValue);
        }
    }

    return join (',', @removeHosts);
}

sub _clearValue {
	my ($self, $itemValue) = @_;
    $itemValue =~ /([A-Z.a-z0-9_-]+)/;
    my $item = $1;
	$item =~ s/^\s+//;
	$item =~ s/\s+$//;
	return $item;
}

sub _setUserInputValues {
	my ($self, $removeHosts) = @_;
	my $config = _getConfig();
    
    my $keepUserCheckBox = $self->{'keepUserCheckBox'};
    my $keepUserValue = $keepUserCheckBox->IsChecked() ? 1 : 0;
    $config->setValue('KeepUser', $keepUserValue);
    
    my $keepHomeDirCheckBox = $self->{'keepHomeDirCheckBox'};
    my $keepHomeDirValue = $keepHomeDirCheckBox->IsChecked() ? 1 : 0;
    $config->setValue('KeepUserHomeDir', $keepHomeDirValue);
}

sub _getConfig {
    return Wx::wxTheApp->{instconfig};
}

sub _onKeepUserCheckBox {
    my ($self, ) = @_;
    my $isChecked = $self->{keepUserCheckBox}->IsChecked();

    if ( $isChecked ) {
        $self->{keepHomeDirCheckBox}->SetValue( 1 );
    }
}

1;