package LCM::Gui::Dialogs::Rename::LSSPropertiesDialog;

use strict;
use warnings;
use parent 'LCM::Gui::Dialogs::LSSPropertiesDialog';
use Wx::Event qw (EVT_CHECKBOX);


sub init {
    my $self = shift();
    my $config = Wx::wxTheApp()->getInstconfig();
# If this is not unskipped it wont show up in the dialog at all.
# Instead, we will enable/disable the control depending on the 
# value of the 'ChangeLSSBackupPassword' checkbox.
    $config->setSkip('TargetLSSBackupPassword', 0);
    $config->{params}->{ChangeLSSBackupPassword}->{str} = "Change the Auto Backup password";

    my $rc = $self->SUPER::init(@_);
    EVT_CHECKBOX($self, $self->getParamCtrl('ChangeLSSBackupPassword')->GetId(), $self->can('_onChangeLSSBackupPassword'));
    $self->_toggleTargetBackupPasswordControl($config->getValueOrBatchValue('ChangeLSSBackupPassword'));

    return $rc;
}

sub getParamKeys {
    my ($self) = @_;
    return [ @{$self->SUPER::getParamKeys()}, 'TargetLSSBackupPassword' ];
}

sub _onChangeLSSBackupPassword {
    my ($self) = @_;
    my $enable = $self->getParamCtrl('ChangeLSSBackupPassword')->IsChecked();
    $self->_toggleTargetBackupPasswordControl($enable);
}

sub _toggleTargetBackupPasswordControl {
    my ($self, $enable) = @_;
    Wx::wxTheApp->getInstconfig()->setValue('ChangeLSSBackupPassword', $enable);

    $self->toggleControlState('TargetLSSBackupPassword', $enable);
}

# Override
sub _getTargetSID {
    my ($self) = @_;
    my $config = Wx::wxTheApp->getInstconfig();
# Return the 'newSID' here as we do not want to disable the fields for the
# LSS user and group IDs because the ones, which contain the old SID, already
# exist. For more details - see implementation of getAlreadySetParamKeys in
# LCM::Gui::Dialogs::LSSPropertiesDialog.
    return $config->getValue('newSID');
}

1;