package LCM::Gui::Dialogs::SelectComponentSourceDialog;

use strict;

use Wx qw ( wxVERTICAL wxHORIZONTAL wxTOP wxLEFT wxRIGHT wxALIGN_LEFT wxEXPAND wxGROW wxALL wxDefaultPosition wxDefaultSize wxDefaultValidator wxICON_EXCLAMATION
	wxID_ADD wxBORDER_SIMPLE wxLC_SINGLE_SEL wxLC_REPORT wxLIST_AUTOSIZE wxOK wxICON_INFORMATION wxLIST_AUTOSIZE_USEHEADER wxICON_ERROR wxCENTRE
	wxTE_MULTILINE wxTE_READONLY wxBORDER_NONE wxLIST_STATE_SELECTED wxLIST_STATE_FOCUSED);
use Wx::Event qw (EVT_BUTTON EVT_LIST_ITEM_SELECTED EVT_LIST_ITEM_FOCUSED);

use SDB::Install::Globals qw($gShortProductNameXS2 $gProductNamePlatform $gXSAAppsOnlyDetectedMessage);
use SDB::Install::Gui::Control::Button;
use SDB::Install::Gui::Design;
use LCM::ComponentManager::MediumComponentManager;
use LCM::Gui::Dialogs::AddComponentSourceDialog;
use File::Basename;
use LCM::Gui::Dialogs::UiComponentsFactory;
use LCM::Gui::ComponentManager::SelectComponentSourceOutputHandler;
use base qw (SAPDB::Install::Wizard::Dialog::Base);

sub new {
	my ( $self ) = shift->SUPER::new ( @_ );
	my $is_gtk1 = Wx::wxGTK1 ();

	$self->{id}   = 'ComponentSource';
	$self->{name} = "Select Software Locations";

	my $sizer = new Wx::BoxSizer ( wxVERTICAL );

	my $title = CreateTitle ($self, 'Select Software Component Locations', $is_gtk1);
	$sizer->Add ( $title, 0, wxLEFT | wxRIGHT | wxTOP, 20 );
	$sizer->AddSpacer ( 5 );

	my $detectedComponentsSizer = $self->_createDetectedComponentsSizer ();

	my $warning = $self->_getWarningTextCtrl();
	$detectedComponentsSizer->Add ( $warning, 0, wxLEFT | wxEXPAND | wxGROW | wxALL, 10 );
	$self->{warning} = $warning;

	$sizer->Add ( $detectedComponentsSizer, 1, wxLEFT | wxEXPAND | wxGROW | wxALL, 20 );

	$self->SetSizer ( $sizer );
	$self->SetAutoLayout ( 1 );
	return $self;
}

sub _createDetectedComponentsSizer {
	my ( $self ) = @_;
	my $sizer = new Wx::BoxSizer ( wxVERTICAL );

	my $title = new Wx::StaticText ( $self, -1, 'Detected Software Components ', wxDefaultPosition,
		wxDefaultSize );
	$sizer->Add ( $title, 0, wxLEFT | wxRIGHT | wxTOP, 0 );
	$sizer->AddSpacer ( 10 );

	my $componentsList = $self->_createComponentsListCtrl ();
	$self->{componentsList} = $componentsList;
	$sizer->Add ( $componentsList, 1, wxLEFT | wxEXPAND | wxGROW | wxRIGHT, 0 );
	$sizer->AddSpacer ( 10 );

	my $buttonsSizer = Wx::BoxSizer->new ( wxHORIZONTAL );
	$self->_addButtons ( $buttonsSizer );
	$sizer->Add ( $buttonsSizer, 0, wxALIGN_LEFT | wxLEFT, 0 );

	return $sizer;
}

sub _getWarningTextCtrl() {
	my ($self) = @_;
    my $warning = new Wx::TextCtrl ( $self, ,-1, "",[-1,-1], [-1,100], wxTE_MULTILINE | wxTE_READONLY | wxBORDER_NONE);
	return $warning;
}

sub _createComponentsListCtrl {
	my ( $self ) = @_;
	my $list = Wx::ListCtrl->new ( $self, 0, wxDefaultPosition, wxDefaultSize, wxBORDER_SIMPLE | wxLC_REPORT | wxLC_SINGLE_SEL | wxEXPAND | wxGROW, wxDefaultValidator );

	$list->InsertColumn ( 0, "Component" );
	$list->InsertColumn ( 1, "Version" );
	$list->InsertColumn ( 2, "Location" );

	$list->SetColumnWidth ( 0, wxLIST_AUTOSIZE_USEHEADER );
	$list->SetColumnWidth ( 1, wxLIST_AUTOSIZE_USEHEADER );
	$list->SetColumnWidth ( 2, wxLIST_AUTOSIZE_USEHEADER );

	EVT_LIST_ITEM_SELECTED($list, $list->GetId, $self->can('_disableSelection'));
	EVT_LIST_ITEM_FOCUSED($list, $list->GetId, $self->can('_disableSelection'));

	return $list;
}

sub _disableSelection {
	my($list, $event) = @_;
	$list->SetItemState($event->GetIndex(), 0, wxLIST_STATE_SELECTED);
	$list->SetItemState($event->GetIndex(), 0, wxLIST_STATE_FOCUSED);
}

sub _addButtons {
	my ( $self, $buttonsSizer ) = @_;

	my $addButton = new SDB::Install::Gui::Control::Button ( $self, wxID_ADD, '&Add Component Location...', wxDefaultPosition, wxDefaultSize );
	EVT_BUTTON ( $self, $addButton->GetId, \&_addButtonAction );
	$buttonsSizer->Add ( $addButton );
	$buttonsSizer->AddSpacer ( 5 );

	my $restoreButton = new SDB::Install::Gui::Control::Button ( $self, -1, '&Restore default', wxDefaultPosition, wxDefaultSize );
	EVT_BUTTON ( $self, $restoreButton->GetId, \&_restoreButtonAction );
	$buttonsSizer->Add ( $restoreButton );
}

sub _addButtonAction {
	my ( $self, $evt ) = @_;

	my $dlg = new LCM::Gui::Dialogs::AddComponentSourceDialog ( $self );
	my $retCode = $dlg->ShowModal ();
	if ( $retCode != $dlg->GetAffirmativeId () ) {
		return;
	}

	my $path = $dlg->GetSelectedPath ();
	my $instconfig = Wx::wxTheApp ()->{instconfig};

	#use new component manager here to override default selection
	my $mcmRef = ref($self->getComponentManager());
	my $mcm = $mcmRef->new($instconfig);
    $mcm->addComponentsOutputHandler($self->getComponentManangerOutputHandler());

	my $rc;
	if ( $dlg->IsSearchRecursive () ) {
	      $rc = $mcm->detectComponentsByFsRoot ( $path, 0 );
	} else {
	      $rc = $mcm->detectComponentsByDirectoryList ( [$path], undef, 1 );
	}
    if($rc == 2 || $rc == 5) {
        my $errorString = $mcm->getErrorString();
	    my $msgDialog = new Wx::MessageDialog ( $self, $errorString, "Error", wxOK | wxICON_ERROR);
	    $msgDialog->ShowModal ();
	    return;
	}
}

sub getDefaultComponentManager {
    my ($self) = @_;
    return $self->{_defaultComponentMgr};
}

sub setDefaultComponentManager {
    my ($self, $mgr) = @_;
    $self->{_defaultComponentMgr} = $mgr;
}

sub _restoreButtonAction {
	my ( $self, $evt ) = @_;
    $self->resetComponentList();
    undef $self->{_componentDirsCsv};
    $self->setComponentManangerOutputHandler(undef);
    $self->_getInstconfig()->setComponentManager($self->getDefaultComponentManager()->clone($self->_getInstconfig()));
    $self->init();
    $self->_setColumnsSize();
}

sub _getComponentListCtrl() {
	return $_[0]->{componentsList};
}

sub _getInstconfig() {
	return Wx::wxTheApp->getActionConfiguration ();
}

sub getComponentManager {
    my $self = shift;
	return $self->_getInstconfig()->getComponentManager ();
}

sub init {
    my ($self) = @_;
    require LCM::ComponentManager::LogDetectedComponentsOutputHandler;
    if (!defined $self->getDefaultComponentManager()) {
        $self->setDefaultComponentManager($self->getComponentManager()->clone($self->_getInstconfig()));
    }
    $self->getComponentManager()->addComponentsOutputHandler($self->getComponentManangerOutputHandler());
    $self->getComponentManager()->addComponentsOutputHandler(LCM::ComponentManager::LogDetectedComponentsOutputHandler->new($self->_getInstconfig()));
	$_[0]->fillDefaultComponentLocations();
	return {};
}

 sub BackInit {
    my ($self) = @_;
    my $mcm = $self->getComponentManager();
    $mcm->{directoryComponents} = [];
    $mcm->addComponentsOutputHandler($self->getComponentManangerOutputHandler());
    return {};
}

sub fillDefaultComponentLocations {
    my($self) = @_;
    $self->getComponentManager()->printDetectedComponents();
}

sub setWarningText() {
	my ($self, $warningText) = @_;
	my $warning = $self->{warning};
	if ($warningText) {
		$warningText = "Warning: ". $warningText;
		$warning->Show(1);
	} else {
		$warningText = "";
		$warning->Show(0);
	}

    $warning->SetValue($warningText);
	return $warning;
}

sub Process {
	my ( $self, $config ) = @_;

	if (!$self->hasSelectedComponents()) {
		Wx::wxTheApp ()->ShowErrorMsg ( "You must select component(s) before next page." );
		return undef;
	}
	return undef if (!$self->setComponentDirs());
	return {};
}

sub hasSelectedComponents {
	my ($self) = @_;
	my @allComponents = ( @{ $self->getComponentManager()->getAllComponents() } );
	return scalar(@allComponents);
}

sub setComponentDirs {
    my($self) = @_;
     $self->getComponentManager()->removeOutputHandler($self->getComponentManangerOutputHandler());
    my $componentsDirCsv = join(',', values(%{$self->{_componentDirsCsv}}));
    return 1 if (!$componentsDirCsv );
    my $config = $self->_getInstconfig();
    if ( ! $config->setValue ( 'ComponentDirs', $componentsDirCsv ) ) {
        Wx::wxTheApp ()->ShowErrorMsg (${$config->{errlst}->{msg_lst}->[0]->getMsgString()});
        $config->resetError();
        return undef;
    }
    return 1;
}

sub _resetParams {
	my ( $self, $componentsDirCsv ) = @_;

	$self->getComponentManager ()->clearDetectedComponents ();

	$self->_getInstconfig ()->resetParam ( 'DvdPath' );
	undef $self->_getInstconfig ()->{params}->{'DvdPath'}->{init_with_default};

	$self->_getInstconfig ()->resetParam ( 'ComponentFsRoot' );
	undef $self->_getInstconfig ()->{params}->{'ComponentFsRoot'}->{init_with_default};

	return $self->_getInstconfig ()->setValue ( 'ComponentDirs', $componentsDirCsv );
}

sub _setColumnsSize {
	my ( $self ) = @_;

	my $listCtrl = $self->_getComponentListCtrl ();
	if ( $listCtrl->GetItemCount () ) {
		return;
	}

	my $numberOfColumns = $listCtrl->GetColumnCount ();
	for ( 0 .. $numberOfColumns ) {
		$listCtrl->SetColumnWidth ( $_, wxLIST_AUTOSIZE_USEHEADER );
	}
}

sub getComponentManangerOutputHandler {
    my ($self) = @_;
    $self->setComponentManangerOutputHandler(LCM::Gui::ComponentManager::SelectComponentSourceOutputHandler->new($self)) if(!defined $self->{listOutput});
    return $self->{listOutput};
}

sub setComponentManangerOutputHandler {
    my ($self, $outputHandler) = @_;
    $self->{listOutput} = $outputHandler;
}

sub addComponentLocation {
    my($self, $component) = @_;
    $self->{_componentDirsCsv} //= {};
    my $componentKeyName = $component->getComponentKeyName();
    $self->{_componentDirsCsv}->{$componentKeyName} = $component->getPath();
}

sub updateComponentList {
    my( $self, $component, $index, $color, $isNewItem, $newLocation) = @_;
    my $listCtrl   = $self->_getComponentListCtrl ();
    return if(!$listCtrl);

    if($isNewItem){
        my $item = new Wx::ListItem ();
        $item->SetId          ( $index );
        $listCtrl->InsertItem ( $item );
    }

    $listCtrl->SetItem ( $index, 0, $component->getComponentName () );
	$listCtrl->SetItem ( $index, 1, $component->getVersion       () );
	$listCtrl->SetItem ( $index, 2, $component->getPath          () );
    $listCtrl->SetItemBackgroundColour ( $index, $color ) if($color);

    $listCtrl->SetColumnWidth ( 0, wxLIST_AUTOSIZE );
	$listCtrl->SetColumnWidth ( 1, wxLIST_AUTOSIZE );
	$listCtrl->SetColumnWidth ( 2, wxLIST_AUTOSIZE );

    if($newLocation){
        $self->addComponentLocation($component);
    }

}

sub resetComponentList {
    my ($self) = @_;
    $self->_getComponentListCtrl()->DeleteAllItems ();
}

1;