package LCM::Gui::Dialogs::SelectComponentsForUpdateDialog;

use LCM::Gui::Dialogs::CertificatesDialog;
use LCM::Gui::Dialogs::StreamingPropertiesDialog;
use LCM::Gui::Dialogs::EsStoragePropertiesDialog;
use LCM::Gui::Dialogs::AcceleratorPropertiesDialog;
use LCM::Gui::Dialogs::XSPropertiesDialog;
use LCM::Gui::Dialogs::XSSpaceIsolationPropertiesDialog;
use LCM::Gui::Dialogs::SelectXsComponentsDialog;
use LCM::Gui::Dialogs::InternalNetworkPropertiesDialog;
use Wx::Event qw (EVT_CHECKLISTBOX);
use LCM::Gui::Dialogs::UpgradeParameterDialog;
use LCM::Gui::Dialogs::Update::AdditionalHostsPropertiesDialog;
use SDB::Install::Globals qw ($gKeynameEngine $gProductNameEngine);
use SDB::Install::Gui::Design;
use strict;

use base qw (LCM::Gui::Dialogs::SelectComponentsDialog);

our $is_gtk1 = 0; #Wx::wxGTK1 ();

sub new{
    my($self) = shift->SUPER::new(@_);
    $self->{id} = 'SelectComponentsForUpdate';
    return $self;
}

sub init{
	my ($self,$config) = @_;
	
	$self->SUPER::init();
	EVT_CHECKLISTBOX($self, $self->{'checklist'}, \&_OnCheckListBox);
	my $sid = $self->_getCurrentSid();
    my $instconfig = Wx::wxTheApp()->getInstconfig();
    if ( $instconfig->isOnlyComponentDetected($gProductNameEngine) ) {
            $self->disableButtonsForComponentsSelection();
    }
	if ($instconfig->isBootstrapFromResident()) {
        my $serverSelectionMessage = $instconfig->getMandatoryServerSelectionMessage();
        $self->{'title'}->SetLabel("Select additional components for update\n\n\n$serverSelectionMessage\n");
	} else {
        $self->{'title'}->SetLabel("Choose components to be installed or updated for system '".$sid."'");
	}
	$self->{'title2'}->SetFont( SDBFONT_NormalText ) if (!$is_gtk1);
	my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
	$self->{'title2'}->SetLabel("Note: Options marked with * require restart of the $flavourProductName System");
	
	$self->_refreshNextButton();	
    return {};
}

sub _OnCheckListBox {
	my ($self, $event) = @_;
	$self->_refreshNextButton();
}

sub _refreshNextButton {
    my $self = shift;

    my $enableNextBtn = 0;
    my $instconfig = Wx::wxTheApp()->{instconfig};
    if ($instconfig->isBootstrapFromResident()) {
        $enableNextBtn = 1;
    } else {
        for my $i (0..$#{$self->{'allComopnents'}}) {
            my $component = $self->{'allComopnents'}->[$i];
            if($self->{'checklist'}->IsChecked($i)) {
                $enableNextBtn = 1;
                last;
            }
        }
    }
    $self->_enableNextButton($enableNextBtn);
}

sub _enableNextButton {
	my ($self, $enable) = @_;
	
	if(!defined $enable or $enable) {
		$self->GetWizard()->EnableNextButton();
	} else {
		$self->GetWizard()->DisableNextButton();
	}
}

sub _getCurrentSid {
	my $app = Wx::wxTheApp ();
	my $instconfig = $app->{'instconfig'};
	return $instconfig->getValue('SID');
}

sub Back{
	$_[0]->GetWizard()->EnableNextButton();
	return 1;
}

1;
