package LCM::Gui::Dialogs::SelectXsComponentsDialog;

use strict;

use parent 'SAPDB::Install::Wizard::Dialog::Base';
use Wx qw (wxVERTICAL wxEXPAND wxTOP wxBOTTOM wxLEFT wxRIGHT wxDefaultPosition wxDefaultSize wxALIGN_LEFT wxOK
             wxCENTRE wxICON_EXCLAMATION wxTE_MULTILINE wxTE_READONLY wxBORDER_NONE wxALL);
use SDB::Install::Gui::Design;
use Wx::Event qw (EVT_BUTTON);
use SDB::Install::Gui::Control::Button;
use LCM::Gui::Dialogs::UiComponentsFactory;
use experimental qw(smartmatch);

our $ID = 'SelectXsComponents';
our $resources = new SAPDB::Install::Resources();
our $images    = $resources->getImages(qw(icon/hint.png));

sub new {
    my($self) = shift->SUPER::new(@_);

    $self->{id} = $ID;
    $self->{name} = "Select XS Advanced Components";

    return $self;
}

sub init {
    my ($self,$config) = @_;

    if(!$self->{initialized}){
        $self->_createUiControls();
        $self->_setInfoText();
        $self->SetAutoLayout (1);
        $self->Layout();
        $self->{initialized} = 1;
    }

    $self->_fillCheckList();
    return {};
}

sub Process {
    my ($self) = @_;
    my $selectedComponents = [];

    for my $i (0..$#{$self->{'allComopnents'}}){
        next if(! $self->{'checklist'}->IsChecked($i));

        my $component = $self->{'allComopnents'}->[$i];
        push(@{$selectedComponents}, $component->getComponentBatchKey());
    }

    my $value = scalar(@{$selectedComponents}) > 0 ? join(',', @{$selectedComponents}) : 'none';
    my $instconfig = Wx::wxTheApp()->getInstconfig();

    $instconfig->resetError ();
    if (!$instconfig->setValue('SelectedXs2Applications', $value)) {
        Wx::MessageBox( $instconfig->GetErrorString (), "Configuration Error", wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
        return undef;
    }
    $self->GetWizard()->RefreshSkippableDialogs();
    return {};
}

sub _fillCheckList{
    my $self = shift;
    my $app = Wx::wxTheApp();
    my $configuration = $app->getInstconfig();

    $self->{'allComopnents'} = [];
    $self->{'checklist'}->Clear();

    my $componentManager = $configuration->getComponentManager();
    my $batchValue = $configuration->getBatchValue('SelectedXs2Applications');
    if (defined($batchValue)){
        $configuration->setValue('SelectedXs2Applications', $batchValue);
    }
    my $index = 0;
    my $scm = $configuration->getSystemComponentManager();
    my @restrictedXs2Apps = keys %{$configuration->getRestrictedXs2AppsMessages()};
    for my $component (@{$componentManager->getXs2ApplicationComponents()}) {
        my $uiString = sprintf("Install %s version %s", $component->getComponentName(), $component->getVersion());
        my $isComponentSelected = $self->_isComponentSelected($configuration, $component);

        if($component->isUpdate()){
            next if(grep{$_ eq $component->getComponentName()} @restrictedXs2Apps);
            my $componentKey = $component->getManifest()->getComponentKey();
            my $existingVersion = $scm->getComponentByKeyName($componentKey)->getVersion();
            $uiString = sprintf("Update %s from version %s to version %s", $component->getComponentName(), $existingVersion, $component->getVersion());
        }

        $self->{'checklist'}->Append($uiString);
        $self->{'checklist'}->Check($index, $isComponentSelected);
        push(@{$self->{'allComopnents'}}, $component);
        $index++;
    }
}

sub _createUiControls {
    my($self) = @_;
    my $is_gtk1 = Wx::wxGTK1();
    my $sizer = new Wx::BoxSizer(wxVERTICAL);

    $self->{title} = CreateTitle($self, 'Choose XS Advanced components to be installed or updated', $is_gtk1);
    $self->{checklist} = CreateCheckListBox($self, $is_gtk1);
    $self->{gridSizerBottom} = new Wx::StdDialogButtonSizer();
    $self->{selectAllBtn} = new SDB::Install::Gui::Control::Button($self, -1, '&Select All', wxDefaultPosition, wxDefaultSize);
	$self->{deselectAllBtn} = new SDB::Install::Gui::Control::Button($self, -1, '&Deselect All', wxDefaultPosition, wxDefaultSize);
    $self->{info_icon} = new Wx::StaticBitmap( $self, -1, new Wx::Bitmap( $images->{'icon/hint.png'} ) );
    $self->{info} = new Wx::TextCtrl( $self, ,-1, "", [-1,-1], [-1,100], wxTE_MULTILINE | wxTE_READONLY | wxEXPAND | wxBORDER_NONE);

    $sizer->Add($self->{title}, 0, wxLEFT | wxRIGHT | wxTOP, 20);
    $sizer->AddSpacer(10);
    $sizer->Add($self->{checklist}, 1, wxEXPAND | wxLEFT | wxRIGHT, 20);
    $sizer->AddSpacer(10);
    $sizer->Add( $self->{info_icon}, 0, wxLEFT | wxTOP, 10 );
    $sizer->Add ( $self->{info}, 1, wxLEFT | wxEXPAND | wxALL, 10 );
    $sizer->Add($self->{gridSizerBottom}, 0, wxALIGN_LEFT | wxBOTTOM , 10);
    $self->{gridSizerBottom}->Add($self->{selectAllBtn}, 0, wxLEFT, 20);
    $self->{gridSizerBottom}->Add($self->{deselectAllBtn}, 0, wxLEFT, 5);

    EVT_BUTTON($self, $self->{selectAllBtn}, \&_onSelectAllBtn);
    EVT_BUTTON($self, $self->{deselectAllBtn}, \&_onDeselectAllBtn);

    $self->SetSizer($sizer);
}

sub _isComponentSelected {
    my ($self, $configuration, $component) = @_;

    return 1 if ($component->isComponentSelected());

    my @defaultValues = split(/\s*,\s*/, $configuration->getDefault('SelectedXs2Applications'));
    return ($component->getComponentBatchKey() ~~ @defaultValues) ? 1 : 0;
}

sub _onSelectAllBtn {
    my ($self, $event) = @_;
    for my $i (0..$#{$self->{'allComopnents'}}){
        $self->{'checklist'}->Check($i, 1);
    }
}

sub _onDeselectAllBtn {
    my ($self, $event) = @_;
    for my $i (0..$#{$self->{'allComopnents'}}){
        $self->{'checklist'}->Check($i, 0);
    }
}

sub _setInfoText() {
    my ($self) = @_;
    my $app = Wx::wxTheApp ();
    my $config = $app->getInstconfig();
    my $info = $self->{info};
    my $infoIcon = $self->{info_icon};

    my $infoText = $config->getRestrictedXs2AppsText() // "";
    $info->AppendText($infoText);

    my $showInfo = $infoText eq "" ? 0 : 1;
    $info->Show($showInfo);
    $infoIcon->Show($showInfo);
}

1;
