package LCM::Gui::Dialogs::StreamingPropertiesDialog;

use SDB::Install::Gui::Design;
use SDB::Install::Globals qw ($gShortProductNameStreaming);
use base qw(SAPDB::Install::Wizard::Dialog::Base);
use strict;
use Wx qw (wxVERTICAL wxLEFT wxEXPAND wxALIGN_CENTER_VERTICAL wxBOTTOM wxALL wxTE_PASSWORD);

sub new{
    my($self) = shift->SUPER::new(@_);

    $self->{id} = 'StreamingProperties';
    $self->{label_text} = "Specify $gShortProductNameStreaming Properties";
    $self->{name} = "Define $gShortProductNameStreaming Properties";

    return $self;
}

sub init {
    my ($self,$config) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->{instconfig};
    my $mainSizer = Wx::BoxSizer->new(wxVERTICAL);
    my $dialogTitle = Wx::StaticText->new($self, -1, $self->{label_text});
    my $gridSizer = Wx::FlexGridSizer->new(6, 2, 5, 15);

    $mainSizer->AddSpacer (20);
    $dialogTitle->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());
    $mainSizer->Add($dialogTitle,0, wxLEFT , 20 );
    $mainSizer->Add ($gridSizer,0, wxEXPAND | (wxALL) & (~wxBOTTOM), 20);
    $self->_addStreamingManagerPasswordControls($gridSizer, $instconfig);
    $self->_addBasepathControls($gridSizer, $instconfig);
    $gridSizer->AddGrowableCol( 1 );
    $self->SetSizerAndFit($mainSizer);
    $self->SetAutoLayout(1);
    $self->Layout();
    $self->Show(1);

    return {}; 
}

sub _addStreamingManagerPasswordControls {
    my ($self, $gridSizer, $instconfig) = @_;

    # Nothing to create if parameter is skipped or not existent
    return unless(exists($instconfig->{params}->{StreamingClusterManagerPassword}));
    return if($instconfig->isSkipped('StreamingClusterManagerPassword'));
    return if($instconfig->isHidden('StreamingClusterManagerPassword'));

    my $passwordParameter = $instconfig->{params}->{StreamingClusterManagerPassword};
    my $isMandatory = $passwordParameter->{mandatory} ? 1 : 0;
    my $value = $instconfig->getValue('StreamingClusterManagerPassword');
    my $passwordString = $passwordParameter->{str};
    $value = '' if(!defined($value));

    my $passwordLabel = SDB::Install::Gui::Control::Label->new( $self, -1, $passwordString, $isMandatory);
    my $passwordControl = new Wx::TextCtrl ($self, -1, $value,[-1,-1], [-1,-1],wxTE_PASSWORD);
    $gridSizer->Add($passwordLabel,0, wxALIGN_CENTER_VERTICAL);
    $gridSizer->Add($passwordControl, 1, wxEXPAND  );
    $self->{_passwordLabel} = $passwordLabel;
    $self->{_passwordControl} = $passwordControl;

    my $passwordConfirmationLabel = SDB::Install::Gui::Control::Label->new( $self, -1, "$passwordString Confirmation", $isMandatory);
    my $passwordConfirmationControl = new Wx::TextCtrl ($self, -1, $value,[-1,-1], [-1,-1],wxTE_PASSWORD);
    $gridSizer->Add($passwordConfirmationLabel,0, wxALIGN_CENTER_VERTICAL);
    $gridSizer->Add($passwordConfirmationControl, 1, wxEXPAND  );
    $self->{_passwordConfirmationLabel} = $passwordConfirmationLabel;
    $self->{_passwordConfirmationControl} = $passwordConfirmationControl;
}

sub _addBasepathControls {
    my ($self, $gridSizer, $instconfig) = @_;

    # Nothing to create if parameter is skipped or not existent
    return unless(exists($instconfig->{params}->{BasepathStreaming}));
    return if($instconfig->isSkipped('BasepathStreaming'));
    return if($instconfig->isHidden('BasepathStreaming'));

    my $basepathParameter = $instconfig->{params}->{BasepathStreaming};
    my $basepathValue = (defined $basepathParameter->{value} ? $basepathParameter->{value} : $instconfig->getDefault('BasepathStreaming'));
    my $isMandatory = $basepathParameter->{mandatory} ? 1 : 0;
    my $isSkipped = $instconfig->isSkipped('BasepathStreaming');
    my $basepathString = $basepathParameter->{str};

    return if($isSkipped);
    $basepathValue = '' if (!defined $basepathValue);

    my $basepathLabel = SDB::Install::Gui::Control::Label->new($self, -1, $basepathString, $isMandatory);
    my $basepathControl = new SAPDB::Install::Control::PathCtrl ($self,-1,$basepathValue, [-1,-1], [-1,-1]);
    $basepathLabel->SetToolTip ($basepathParameter->{desc});
    $basepathControl->SetToolTip($basepathParameter->{desc});
    $gridSizer->Add($basepathLabel,0, wxALIGN_CENTER_VERTICAL);
    $gridSizer->Add($basepathControl, 1, wxEXPAND  );
    $self->{_basepathLabel} = $basepathLabel;
    $self->{_basepathControl} = $basepathControl;
}

sub Process {
    my ($self,) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = LCM::Gui::DialogUtilities::GetAppConfig();

    $instconfig->resetError ();

    if(!$self->_setStreamingClusterManagerPassword($app, $instconfig)){
        return undef;
    }
    if(!$self->_setBasepathStreaming($app, $instconfig)){
        return undef;
    }
    return {};
}

sub _setBasepathStreaming {
    my ($self, $app, $instconfig) = @_;
    my $basepathControl = $self->{_basepathControl};

    return 1 unless(defined($basepathControl)); # Nothing to do if control does not exist

    my $basepathValue = $basepathControl->GetValue();

    if (! $instconfig->setValue('BasepathStreaming', $basepathValue)) {
        $app->ShowErrorMsg( "Invalid Basepath Streaming value", $instconfig->getErrMsgLst() );
        $basepathControl->SetFocus();
        return undef;
    }
    return 1;
}

sub _setStreamingClusterManagerPassword {
    my ($self, $app, $instconfig) = @_;
    my $passwordControl = $self->{_passwordControl};
    my $passwordConfirmationControl = $self->{_passwordConfirmationControl};

    # Nothing to do if controls do not exist
    return 1 unless(defined($passwordControl) && defined($passwordConfirmationControl));

    my $passwordValue = $passwordControl->GetValue();
    my $passwordConfirmationValue = $passwordConfirmationControl->GetValue();

    if(! $passwordValue) {
        $app->ShowErrorMsg( "Streaming Cluster Manager Password is empty" );
        $passwordControl->SetFocus();
        return undef;
    }

    if($passwordValue ne $passwordConfirmationValue) {
        $app->ShowErrorMsg( "Password confirmation doesn't match" );
        $passwordControl->SetFocus();
        return undef;
    }
    if(! $instconfig->setValue('StreamingClusterManagerPassword', $passwordValue)) {
        $app->ShowErrorMsg( "Invalid Password", $instconfig->getErrMsgLst() );
        $passwordControl->SetFocus();
        return undef;
    }
    return 1
}

sub Back {
    my ($self) = @_;
    $self->Reset();
}

sub Reset {
    my ($self) = @_;

    if(defined $self->GetSizer()){
        $self->GetSizer->Clear (1);
    }
    delete($self->{_passwordLabel});
    delete($self->{_passwordControl});
    delete($self->{_passwordConfirmationLabel});
    delete($self->{_passwordConfirmationControl});
    delete($self->{_basepathLabel});
    delete($self->{_basepathControl});
    $self->SUPER::Reset();
}

sub Destroy {
    my ($self) = @_;
    $self->Reset();
    $self->SUPER::Destroy;
}

sub DESTROY {
    my ($self) = @_;
    print ">>>>> destroying $self\n" if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;