package LCM::Gui::Dialogs::Uninstall::SelectComponentsDialog;

use strict;
use parent 'SAPDB::Install::Wizard::Dialog::Base';
use Wx qw(wxVERTICAL wxHORIZONTAL wxALIGN_CENTER wxEXPAND wxTOP wxLEFT wxRIGHT);
use Wx::Event qw (EVT_SIZE EVT_RADIOBUTTON EVT_CHECKLISTBOX);
use SAPDB::Install::Resources;
use SDB::Install::Globals qw($gProductNameEngine);
use SDB::Install::SysVars qw($isWin);
use SDB::Install::System qw (isAdmin);
use SDB::Install::Gui::Design;
use LCM::Component;
use LCM::Gui::Dialogs::UiComponentsFactory;
use experimental qw (smartmatch);

our $resources = new SAPDB::Install::Resources ();
our $images = $resources->getImages (qw(icon/warning.png));

sub new {
    my($self) = shift->SUPER::new(@_);
    my $app = Wx::wxTheApp ();
    my $instconfig = $app->getInstconfig();
    my $is_gtk1 = Wx::wxGTK1 ();
    my $sizer = new Wx::BoxSizer(wxVERTICAL);

    $self->{id} = 'SelectComponentsForUninstall';
    $self->{name} = "Select Components";
    $self->{lastSelectedSid} = '';

    if(! isAdmin()){
        my $warnigsSizer = $self->_createWarningsSizer("Uninstallation of $gProductNameEngine is possible with root privileges only");
        $sizer->Add($warnigsSizer, 0, wxEXPAND);
    }

    $self->{'title'} = CreateTitle($self, 'Choose components to be uninstalled', $is_gtk1);
    $sizer->Add($self->{'title'}, 0, wxLEFT | wxRIGHT | wxTOP, 20);
    $sizer->AddSpacer(12);	
 
    $self->{'rb_uninstall_all'} = CreateRadioButton($self, "&Uninstall ". $instconfig->getAllComponentsUiValue(), $is_gtk1);
    $sizer->Add($self->{'rb_uninstall_all'}, 0, wxLEFT | wxRIGHT, 20);
    $sizer->AddSpacer(12);
    EVT_RADIOBUTTON($self, $self->{'rb_uninstall_all'}->GetId(), \&OnRBUninstallAll);

    $self->{'rb_uninstall_separate'} = CreateRadioButton($self, "Uninstall &separate components", $is_gtk1);
    $sizer->Add($self->{'rb_uninstall_separate'}, 0, wxLEFT | wxRIGHT, 20);
    $sizer->AddSpacer(5);
    EVT_RADIOBUTTON($self, $self->{'rb_uninstall_separate'}->GetId(), \&OnRBUninstallSeparate);

    $self->{'checklist'} = CreateCheckListBox($self, $is_gtk1);
    $sizer->Add($self->{'checklist'}, 1, wxEXPAND | wxLEFT | wxRIGHT, 32);
    $sizer->AddSpacer(12);
    EVT_CHECKLISTBOX($self, $self->{'checklist'}, \&OnCheckListBox);

    my $forceParamaterString = $instconfig->getString('ForceRemoveHosts');
    my $forceParamaterValue = $instconfig->getValueOrBatchValue('ForceRemoveHosts');
    $self->{'force_checkbox'} = new Wx::CheckBox($self, -1, $forceParamaterString, [-1,-1], [-1,-1]);
    $self->{'force_checkbox'}->SetValue($forceParamaterValue);
    $sizer->Add($self->{'force_checkbox'}, 0, wxLEFT | wxRIGHT, 20);

    $self->SetSizer($sizer);
    $self->{'rb_uninstall_all'}->SetFocus();
    $self->SetAutoLayout (1);

    return $self;
}

sub _createWarningsSizer {
    my ($self, $message) = @_;
    my $isGtk1 = Wx::wxGTK1 ();
    my $warningSizer = new Wx::BoxSizer(wxHORIZONTAL);
    my $warningsIcon = Wx::StaticBitmap->new($self, -1, new Wx::Bitmap ($images->{'icon/warning.png'}));
    my $warningsText = Wx::StaticText->new($self, -1, $message);
    my $resizeHandler = sub {
        my ($dialog, $evt) = @_;
        $warningsText->SetLabel($message);
        $warningsText->Wrap(($dialog->GetSizeWH())[0] - 10 - 20 - 20);
        $dialog->Layout();
    };

    EVT_SIZE($self, $resizeHandler);
    $warningsText->SetFont(SDBFONT_NormalText) if (!$isGtk1);
    $warningSizer->Add($warningsIcon, 0,wxLEFT | wxTOP, 20);
    $warningSizer->AddSpacer(10);
    $warningSizer->Add($warningsText,0, wxEXPAND | wxTOP | wxALIGN_CENTER, 20);

    return $warningSizer
}

sub OnRBUninstallAll{
	my ($self, $evt) = @_;
	for my $i (0..$#{$self->{'allComopnents'}}) {
		$self->{'checklist'}->Deselect($i);
	}
	$self->GetWizard()->{'nbutton'}->Enable(1);
	$self->{'checklist'}->Enable(0);
	$self->{'force_checkbox'}->Enable(0);
}

sub OnRBUninstallSeparate{
	my ($self, $evt) = @_;
	$self->GetWizard()->{'nbutton'}->Enable(0);
	$self->{'checklist'}->Enable(1);
	$self->{'force_checkbox'}->Enable(1);
	$self->OnCheckListBox();
}

sub OnCheckListBox {
	my ($self, $evt) = @_;
	my $enableNextBtn = 0;

	for my $i (0..$#{$self->{'allComopnents'}}) {
		my $component = $self->{'allComopnents'}->[$i];

		if($self->{'checklist'}->IsChecked($i)) {
			$enableNextBtn = 1;
			last;
		}
	}

	$self->GetWizard()->{'nbutton'}->Enable($enableNextBtn);
}

sub init{
	my ($self,$config) = @_;
	my $sid = $self->getCurrentSid();
	my $app = Wx::wxTheApp();
	my $instconfig = $app->getInstconfig();
	if(!$instconfig->setBatchValueOfRequiredParams('AutoInitializeServices')){
		$app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
		return undef;
	}

	$self->{'title'}->SetLabel("Choose components to be uninstalled for system '".$sid."'");
	$self->initControlsWithCurrentState();
# initControlsWithCurrentState selects the components based on
# the --components batch value and must be before fillCheckList
	$self->fillCheckList();
	$self->Layout();
	return {};
}

sub fillCheckList{
	my $self = shift;
	my $app = Wx::wxTheApp();
	my $instconfig = $app->getInstconfig();

	my $ownSystemComponentrManager = $instconfig->{componentManager}->getSystemComponentManager();
	my ($orderedKeynames, $componentKeynameToAction) = $instconfig->getComponentKeynameToAction();
	my $index = 0;

	$self->{'allComopnents'} = [];
	$self->{'checklist'}->Clear();

	for my $componentKeyname ( @{$orderedKeynames} ) {
		my $component = $ownSystemComponentrManager->getComponentByKeyName($componentKeyname);
		if ($component->isInternal() or !$component->canSelectComponent()) {
			next;
		}
		push(@{$self->{'allComopnents'}}, $component);
		$self->{'checklist'}->Append($componentKeynameToAction->{$componentKeyname});
		$self->{'checklist'}->Check($index, $component->isComponentSelected());
		$index++;
	}

	if(!$index){
		$self->{'rb_uninstall_separate'}->Enable(0);
	}
	return;
}

sub getExternalComponentsForUninstallation {
	my ($self, ) = @_;

	my $app = Wx::wxTheApp();
	my $instconfig = $app->getInstconfig();

	my ($orderedKeynames, $componentKeynameToAction) = $instconfig->getComponentKeynameToAction();
	my $ownSystemComponentrManager = $instconfig->{componentManager}->getSystemComponentManager();
	my @components = ();

	for my $componentKeyname ( @{$orderedKeynames} ) {
		my $component = $ownSystemComponentrManager->getComponentByKeyName($componentKeyname);
		if ($component->isInternal()) {
			next;
		}
		push(@components, $component);
	}

	return @components;
}

sub initControlsWithCurrentState {
	my $self = shift;
	my $app = Wx::wxTheApp ();
	my $selectedComponents = $self->_getSelectedComponentsBatchValue();
	my $isCompleteUninstall = ($selectedComponents =~ /,*all,*/) ? 1 : 0;
	my $isAdmin = isAdmin();

	if (! $isAdmin || (defined($selectedComponents) && !$isCompleteUninstall) ) {
		$self->{'rb_uninstall_separate'}->SetFocus();
		$self->{'rb_uninstall_separate'}->SetValue(1);
		$self->{'rb_uninstall_all'}->Enable($isAdmin);
		$self->OnRBUninstallSeparate();
	} else {
		$self->{'rb_uninstall_all'}->SetFocus();
		$self->{'rb_uninstall_all'}->SetValue(1);
		$self->OnRBUninstallAll();
	}
}

sub _getSelectedComponentsBatchValue {
	my ($self) = @_;
	my $app = Wx::wxTheApp ();
	my $instconfig = $app->getInstconfig();
	my $selectedComponents = $instconfig->getBatchValue('SelectedComponents');
	my $validValues = $instconfig->getValidValues('SelectedComponents') || [];
	return undef if (!defined $selectedComponents);

	for my $batchKey (split(',', $selectedComponents)) {
		return undef if (! ($batchKey ~~ @$validValues));
	}

	my $oldContext = $instconfig->setMsgLstContext([new SDB::Install::MsgLst(), new SDB::Install::MsgLst()]);
	for my $batchKey (split(',', $selectedComponents)) {
		return undef if (!$instconfig->checkValue('SelectedComponents', $batchKey));
	}
	$instconfig->setMsgLstContext($oldContext);
	return $selectedComponents;
}

sub getCurrentSid {
	my $app = Wx::wxTheApp ();
	my $instconfig = $app->getInstconfig();
	return $instconfig->getValue('SID');
}

sub Process{
	my ($self,$config) = @_;
	my $selectedComponentsCsv="";

	if($self->{'rb_uninstall_separate'}->GetValue()) {
		for my $i (0..$#{$self->{'allComopnents'}}){
			my $component = $self->{'allComopnents'}->[$i];
			my $batchKey = $component->getComponentBatchKey();;
			
			if($self->{'checklist'}->IsChecked($i)){
				$selectedComponentsCsv .= $batchKey;
				if( $i < ($#{$self->{'allComopnents'}})){
					$selectedComponentsCsv .= ",";
				}
			}
		}
	} else {
		$selectedComponentsCsv = "all";
	}	

	my $app = Wx::wxTheApp();
	my $instconfig = $app->getInstconfig();
	$instconfig->ResetError();

	my $rc = $instconfig->setValue('SelectedComponents', $selectedComponentsCsv);
	if (!$rc) {
		$app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
		return undef;
	}
	if ($self->{'force_checkbox'}->IsEnabled()) {
		my $checkBoxValue = $self->{'force_checkbox'}->GetValue();
		$checkBoxValue = 0 if ($checkBoxValue eq ''); # good job Wx
		$rc = $instconfig->setValue('ForceRemoveHosts', $checkBoxValue);
		if (!$rc) {
			$app->ShowErrorMsg ('Configuration error', $instconfig->getErrMsgLst());
			return undef;
		}
	}

	$self->GetWizard()->RefreshSkippableDialogs();
	return {};
}

1;