package LCM::Gui::Dialogs::UninstallDialog::ProgressHandler;

use strict;
use SDB::Install::Gui::Dialogs::Install;
use SDB::Common::Utils qw(trim);
our @ISA = qw(SDB::Install::Gui::Dialogs::PackageProgressHandler);

sub new {
    my $self = shift->SUPER::new (@_);
    $self->{label} = $_[1];
    $self->{id} = 'uninstallProgressHandler';
    return $self;
}

sub addLine {
    my ($self, $text) = @_;
    $self->{label}->SetLabel(trim($text));
    $self->SetProgress ($text);
}

1;
package LCM::Gui::Dialogs::UninstallDialog;

use strict;
use Wx qw (wxEXPAND wxLEFT wxBOTTOM);
use parent qw (SDB::Install::Gui::Dialogs::Install);
use LCM::Gui::TaskExecutionPlan;

sub new {
	my $self = shift->SUPER::new (@_);
	$self->{name} = 'Uninstall Software';
	$self->{id} = 'uninstall';
	return $self;  
}

sub init{
    my ($self,$config) = @_;
    
    $self->GetWizard()->KillPreviousDialogs();
    $self->{progressLabel} = new Wx::StaticText($self, -1, '');
    $self->GetSizer()->Add( $self->{progressLabel}, 0, wxEXPAND | wxLEFT | wxBOTTOM, 20);
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getInstconfig();
    $self->{'caption'}->SetLabel(sprintf ("Uninstalling Software of System %s ", $instconfig->getValue ('SID')) );
    
    return {'auto_next' => 1};
}

sub Process{
    my ($self,$config) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->{'instconfig'};
    my $processTask = $self->createExecutor($instconfig);
    my $returnStatus = {};

    $instconfig->{processTask} = $processTask;
    $instconfig->dumpConfigFile('hdblcmgui');
    $app->setExecutor($processTask);
    $processTask->execute();

    if($processTask->getStatus()->isInErrorState()) {
        $app->ShowErrorMsg("Uninstallation failed", $processTask->getErrMsgLst());
        $returnStatus = {'error_state' => 1};
    }

    $app->handleExecutorMsgLst();
    return $returnStatus;
}

sub InitProgress($$$$){
	my ($self, $tasks) = @_;
	$self->{'plan'}->init($tasks,{'with_progress' => 1});
	$self->GetWizard()->LayoutDlg();
	Wx::Yield ();
}

sub createExecutor() {
	require LCM::Task::UninstallationProcessTask;

	my ($self, $configuration) = @_;
	my $processTask = new LCM::Task::UninstallationProcessTask($configuration);
	my $progressHandler = new LCM::Gui::Dialogs::UninstallDialog::ProgressHandler($self->{plan}, $self->{progressLabel});

	for my $subtask (@{$processTask->getSubtasks()}){
		$subtask->addListener($progressHandler);
	}
	$self->InitProgress($processTask->getSubtasks());
	return $processTask;
}

# Override
sub _createExecutionPlan {
	my ($self) = @_;
	return LCM::Gui::TaskExecutionPlan->new($self,-1);
}

1;
