package LCM::Gui::Dialogs::Update::ResumePendingUpdatePropsDialog;

use strict;

use Wx;
use base qw (LCM::Gui::Dialogs::GenericCredentialsDialog);

our $ID = 'ResumePendingUpdateDialog';


sub new{
    my($self) = shift->SUPER::new(@_);

    $self->{id} = $ID;
    $self->{label_text} = "Enter Pending Update Properties";
    $self->{name} = "Define Pending Update Properties";
    return $self;
}

sub init{
    my $self = shift;
    $self->setBatchValueOfRequiredParams();
    $self->SUPER::init();
}

sub getParamIds{
    my ($self, $instconfig) = @_;
    my $paramIds = ['SID'];
    my $passwordParams = $self->addPasswordParameters();
    push(@$paramIds,@$passwordParams);
    return $paramIds;
}

sub createControls{
    my ($self,$gridSizer,$config) = @_;
    $self->SUPER::createControls($gridSizer,$config);
    my $sidControl = $self->getParameterControl('SID');
    $sidControl->Enable(0) if(defined $sidControl);
}

sub _shouldAddRootUserCtrl {
	my ($self, $instconfig) = @_;

	my $isRootUserSkipped = $instconfig->isSkipped('RootUser');

	if ($isRootUserSkipped) {
		return 0;
	}

	my $isRootPassSkipped = $instconfig->isSkipped('RootPassword');
	my $persFileValue = $instconfig->{params}->{RootUser}->{persFileValue};
	my $value = $instconfig->getValue('RootUser');

	# Don't show RootUser text ctrl in hdblcm resume update,
	# if value is deserialized and RootPassword is unnecessary.
	if (!$isRootUserSkipped && $persFileValue && $value && $isRootPassSkipped) {
		return 0;
	}

	return 1;
}

sub addPasswordParameters{
    my ($self ) = @_;
    my $app = Wx::wxTheApp();
    my $instconfig = $app->getInstconfig();
    my $paramIds = [];
    foreach my $id (@{$instconfig->getParamIds()}){
        next if (!$instconfig->isInteractive($id));
        next if ($instconfig->isSkipped($id));
        next if ($instconfig->getType($id) !~ /passwd/);
        next if ($id eq 'RootPassword' && !$self->_shouldAddRootUserCtrl($instconfig));
        my $userParamId = $instconfig->getUserParameterId($id);
        if ($userParamId){
            push(@$paramIds,$userParamId);
        }
        push(@$paramIds,$id);
    }
    return $paramIds;
}

sub setBatchValueOfRequiredParams {
    my ($self) = @_;
    my $app = Wx::wxTheApp;
    my $instconfig = $app->getInstconfig();
    my $paramKeys = $instconfig->getParamIds();
    my $lastParamId = $paramKeys->[-1];
    return 1 if (!defined $lastParamId);

    my $rc = $instconfig->setBatchValueOfRequiredParams($lastParamId);
    if (!defined $rc) {
        $app->ShowErrorMsg ('Initialize configuration failed', $instconfig->getErrMsgLst ());
    }
    return $rc;
}
1;
