package LCM::Gui::Dialogs::UpdateHosts::ProgressHandler;

use SDB::Install::Gui::Dialogs::Install;
use LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration qw( $PROGRESS_MSG_FILTER_REMOTE $PROGRESS_MSG_FILTER);
use SDB::Common::Utils qw( trim );

our @ISA = ( 'SDB::Install::Gui::Dialogs::PackageProgressHandler' );

sub new {
    my $self = shift;
    $self = $self->SUPER::new ( @_ );
    $self->{label} = $_[1];
    $self->{id} = 'UpdateHostProgressHandler';
    $self->{value} = 0;
    return $self;
}

sub setParentProgressHandler{
	my($self, $parent) = @_;
	$self->{parent} = $parent;
}

sub SetProgress ($$) {
    my ($self,$msg) = @_;
    if(defined $msg){
    	$msg = trim($msg);
    }
    if(!defined $self->{parent}){
    	if ($self->_canShowProgress($msg)){
        	$self->{label}->SetLabel ($msg);
    	}
    	$self->SUPER::SetProgress($msg);
    }
    else{
    	if ($self->_canShowProgress($msg) && defined $self->{parent}->{label}){
        	$self->{parent}->{label}->SetLabel ($msg);
    	}
    	$self->{parent}->SetProgress($msg);
    }    
}

sub addLine ($$);
*addLine = \&SetProgress;

sub _canShowProgress{
	my ($self,$msg) = @_;
	return $msg =~ /$PROGRESS_MSG_FILTER/ || $msg =~ /$PROGRESS_MSG_FILTER_REMOTE/;
}
1;