package LCM::Gui::Wizard::GenericStackWizard;
use strict;

use base 'SDB::Install::Gui::Window::Wizard';
use LCM::Gui::Dialogs::SelectComponentSourceDialog;
use LCM::Gui::Dialogs::SelectActivityExternalDialog;
use LCM::Gui::Dialogs::SelectActivityInstalledDialog;
use LCM::Gui::Dialogs::Cockpit::SelectActivityCockpitExternalDialog;
use SDB::Install::Globals qw($gFlavourCockpit);
use LCM::Gui::Controllers::ControllersFactory qw (CreateControllerForScenario);

sub new {
    my $self = shift->SUPER::new (@_);
	$self->{dialogToSkipPredicate} = {};
    return $self;
}

sub initWizard{
    my ($self, $isInSimpleMode) = @_;
   
    my $installer = new LCM::Installer ();
	if ($installer->isInstalled()){
		$self->AddDialog (new LCM::Gui::Dialogs::SelectActivityInstalledDialog ($self));
	} else {
		$self->AddDialog (new LCM::Gui::Dialogs::SelectComponentSourceDialog ($self)) if(!$isInSimpleMode);
		my $app = Wx::wxTheApp();
        my $flavour = $app->getFlavour(1);
        if($flavour eq $gFlavourCockpit){
            $self->AddDialog (LCM::Gui::Dialogs::Cockpit::SelectActivityCockpitExternalDialog->new($self));
        }
        else{
            $self->AddDialog (new LCM::Gui::Dialogs::SelectActivityExternalDialog ($self));
        }
	}
	
    $self->init ();
    $self->SkipDialog('finalize', 1);
}

sub InsertDialog {
	my ($self, $dlg, $id, $condensed_id, $shouldSkipPredicate) = @_;
	
	my $rc = $self->SUPER::InsertDialog($dlg, $id, $condensed_id);
	if (not $rc) {
		return $rc;
	}
	
	if (defined $shouldSkipPredicate) {
		$self->{dialogToSkipPredicate}->{$dlg->GetID()} = $shouldSkipPredicate;
	}
}

sub RemoveDialog{
    my ($self, $id) = @_;

    my $rc = $self->SUPER::RemoveDialog($id);
    if (not $rc) {
        return $rc;
    }

    delete ($self->{dialogToSkipPredicate}{$id});
    return 1;
}

sub RefreshSkippableDialogs {
	my $self = shift;
	
	for my $dialogId (keys %{$self->{dialogToSkipPredicate}}) {
		my $shallSkipDialog = $self->{dialogToSkipPredicate}->{$dialogId}->() ? 1 : 0;
		$self->SkipDialog($dialogId, $shallSkipDialog);
	}
 }

sub getController{
    my $self = shift;
    my $app = Wx::wxTheApp;
    my $config = $app->getInstconfig();
    if(!defined $self->{controller}){
        $self->{controller} = CreateControllerForScenario($config->getAction(), $config, $self);
    }
    return $self->{controller};
}

sub resetController{
    my $self = shift;
    $self->{controller} = undef;
    $self->{dialogToSkipPredicate} = undef;
}

1;
