package LCM::Landscape::PDXml;

use strict;
use File::Spec;
use LCM::Landscape::Product;
use SDB::Common::Utils qw(createXMLParser);

sub new {
	require XML::LibXML;

	my ($class, $systemComponentManager, $rootDirectory, $messagingContext) = @_;
	my $self = bless({}, $class);
	my $pdXmlFile = File::Spec->catfile($rootDirectory, 'PD.XML');

	_addMessage($messagingContext, "Parsing $pdXmlFile...");

	my $parser = createXMLParser();
	my $xmlTree = $parser->parse_file($pdXmlFile);

	$self->_detectProduct($systemComponentManager, $xmlTree, $messagingContext);

	return $self;
}

sub getProduct {
	my ($self) = @_;
	return $self->{product};
}

sub _setProduct {
	my ($self, $product) = @_;
	$self->{product} = $product;
}

sub _detectProduct {
	my ($self, $systemComponentManager, $xmlTree, $context) = @_;
	my $productVersionNode = $xmlTree->getElementsByTagName('product-version')->[0];

	_addMessage($context, "Reading product information...");

	my $product = new LCM::Landscape::Product($systemComponentManager, $productVersionNode, $context);
	$self->_setProduct($product);
}

sub _addMessage {
	my ($context, $message) = @_;
	$context->getMsgLst()->addMessage($message) if($context);
}

1;