package LCM::Landscape::Properties;

use strict;
use File::Spec;
use SDB::Install::User;
use SDB::Install::MsgLst;
use parent 'SDB::Install::Base';
use SDB::Install::SysVars qw($isWin);
use SDB::Common::Utils qw(trim createSysAdminUserName);
use LCM::FileUtils qw(readFile writeToFile createDirectory);

my $FILE_MODE = 0755;
my $LINE_SEPARATOR = "\n";

sub store {
	my ($self, $sid, $targetDirectory) = @_;
	my ($uid, $gid) = (undef, undef);
	my $errorList = new SDB::Install::MsgLst();
	my $filePath = File::Spec->catfile($targetDirectory, $self->_getPopertiesFileName());
	my $fileContent = (-e $filePath) ? $self->_getUpdatedFileContent($filePath) : $self->_createFileContent();

	if(!defined($fileContent)){
		return undef;
	}
	if(!$isWin){
		my $sidadmUserName = createSysAdminUserName($sid);
		my $sidadmUser = new SDB::Install::User($sidadmUserName);
		($uid, $gid) = ($sidadmUser->id(), $sidadmUser->gid());
	}
	if(!-d $targetDirectory && !createDirectory($targetDirectory, $FILE_MODE, $uid, $gid, undef, $errorList)){
		$self->getErrMsgLst()->addError("Failed to create directory '$targetDirectory'", $errorList);
		return undef;
	}
	my $fileContentToString = join($LINE_SEPARATOR, @{$fileContent}) . $LINE_SEPARATOR;
	if(!writeToFile($filePath, $fileContentToString , $FILE_MODE, $uid, $gid, $errorList)){
		$self->getErrMsgLst()->addError("Failed to write file '$filePath' to the file system", $errorList);
		return undef;
	}
	return 1;
}

sub _getPopertiesFileName {
	...
}

sub _getPropertyModels {
	...
}

sub _getUpdatedFileContent {
	my ($self, $filePath) = @_;
	my $errMsgLst = new SDB::Install::MsgLst();
	my $lines = readFile($filePath, $errMsgLst);

	if(!defined($lines)){
		$self->getErrMsgLst()->addError("Failed to read file '$filePath'.", $errMsgLst);
		return undef;
	}

	for(my $i = 0; $i < scalar(@{$lines}); ++$i){
		for my $propertyModel (@{$self->_getPropertyModels()}){
			my $regex = $propertyModel->{regex};

			$lines->[$i] = trim($lines->[$i]);
			next if($lines->[$i] !~ /$regex/);

			my $template = $propertyModel->{template};
			my $getMethod = $propertyModel->{getter};
			my $value = $self->$getMethod();
			if(defined($value)){
				$lines->[$i] = sprintf($template, $value);
			}
		}
	}
	return $lines;
}

sub _createFileContent {
	my ($self) = @_;
	my $lines = [];

	for my $propertyModel (@{$self->_getPropertyModels()}){
		my $getMethod = $propertyModel->{getter};
		my $template = $propertyModel->{template};
		my $comment = $propertyModel->{comment};
		my $value = $self->$getMethod();

		push(@{$lines}, @{$comment}, sprintf($template, $value));
	}
	return $lines;
}

1;