package LCM::Landscape::Properties::LandscapeVariables;

use strict;
use LCM::FileUtils qw(readFile);
use experimental qw(smartmatch);
use parent 'LCM::Landscape::Properties';

my $PROPERTY_MODELS = [{
		getter => 'getLandscapeSid',
		template => 'SID=%s',
		regex => '^SID\s*=',
		comment => [],
	}, {
		getter => 'getLandscapeInstallationNumber',
		template => 'installationNumberHDB=%s',
		regex => '^installationNumberHDB\s*=',
		comment => [
			'# ------------------------------',
			'# specify the installation number',
			'# - - - - - - - - - - - - - - - -',
			'# this numnber identifies the system with respect',
			'# to licensing',
			'# ------------------------------',
		],
	}, {
		getter => 'getLandscapeCentralServer',
		template => 'centralserver=%s',
		regex => '^centralserver\s*=',
		comment => [],
	}, {
		getter => 'getLandscapeInstallationPath',
		template => 'sapmntPath=%s',
		regex => '^sapmntPath\s*=',
		comment => [],
	},
];
my $LANDSCAPE_PROPERTIES_FILE = 'landscapeVariables.properties';

sub new {
	my ($class, $messageListContext, $sapSystem) = @_;
	my $self = $class->SUPER::new();
	my $sid = $sapSystem->get_sid();
	my $trexInstance = $sapSystem->getNewDBInstances()->[0];
	my $centralServer = $trexInstance->getActiveMaster() || $trexInstance->get_host();
	my $installationPath = $sapSystem->get_target() || '/usr/sap/';
	my $installationNumber = $self->_retrieveInstallationNumber($trexInstance);

	$self->setMsgLstContext($messageListContext) if(defined($messageListContext));
	$self->_setLandscapeSid($sid);
	$self->_setLandscapeInstallationNumber($installationNumber);
	$self->_setLandscapeCentralServer($centralServer);
	$self->_setLandscapeInstallationPath($installationPath);

	return $self;
}

sub getLandscapeSid {
	my ($self) = @_;
	return $self->{_landscapeSid};
}

sub getLandscapeInstallationNumber {
	my ($self) = @_;
	return $self->{_installationNumber};
}

sub getLandscapeCentralServer {
	my ($self) = @_;
	return $self->{_centralServer};
}

sub getLandscapeInstallationPath {
	my ($self) = @_;
	return $self->{_installationPath};
}

sub _setLandscapeSid {
	my ($self, $sid) = @_;
	$self->{_landscapeSid} = $sid;
}

sub _setLandscapeInstallationNumber {
	my ($self, $installationNumber) = @_;
	$self->{_installationNumber} = $installationNumber;
}

sub _setLandscapeCentralServer {
	my ($self, $centralServer) = @_;
	$self->{_centralServer} = $centralServer;
}

sub _setLandscapeInstallationPath {
	my ($self, $installationPath) = @_;
	$self->{_installationPath} = $installationPath;
}

sub _retrieveInstallationNumber {
	my ($self, $trexInstance) = @_;
	my $metadataDir = $trexInstance->get_globalMetadataDir();
	my $installPropertiesFile = File::Spec->catfile($metadataDir, 'installation.properties');
	my $lines = readFile($installPropertiesFile, new SDB::Install::MsgLst()) || []; # Ignore errors

	for my $line (@{$lines}){
		if($line =~ /^\s*installno\s*=\s*(.+)$/){
			my $installationNumber = $1;
			$installationNumber =~ s/\s//g;
			return $installationNumber;
		}
	}
	return '0000000000';
}

# Override
sub _getPopertiesFileName {
	return $LANDSCAPE_PROPERTIES_FILE;
}

# Override
sub _getPropertyModels {
	return $PROPERTY_MODELS;
}

1;