package LCM::Manifests::ManifestFactory;

use strict;
use warnings;
use LCM::Manifests::CockpitStackManifest;
use LCM::Manifests::GenericManifest;
use LCM::Manifests::ResidentInstallerManifest;
use LCM::Manifests::XS2ApplicationManifest;
use SDB::Install::System qw (isRegularFile);


sub createComponentManifest {
    my ($manifestPath) = @_;
    if (_isXSAppArchive($manifestPath)){
        return LCM::Manifests::XS2ApplicationManifest->new($manifestPath);
    }

    my $manifest = LCM::Manifests::GenericManifest->new($manifestPath);
    if ($manifest->isCockpitStack()) {
        $manifest = LCM::Manifests::CockpitStackManifest->new($manifestPath);
    } elsif ($manifest->isInstaller()) {
        $manifest = LCM::Manifests::ResidentInstallerManifest->new($manifestPath);
    }

    return $manifest;
}

sub _isXSAppArchive {
    my ($manifestPath) = @_;
    my $isRegularFile = SDB::Install::System::isRegularFile($manifestPath);
    my $isZip = $isRegularFile && ($manifestPath =~ /\.zip$/i);
    return $isZip ? 1 : 0;
}

1;