package LCM::Persistence::XMLBase;

use strict;

use parent 'SDB::Install::Base';

sub new {
	my ($class, $filePath) = @_;
	my $self = $class->SUPER::new();

	$self->_setFilePath($filePath);

	return $self;
}

sub getFilePath {
	my ($self) = @_;
	return $self->{_filePath};
}

sub getSourceVersionString {
	...
}

sub getTargetVersionString {
	...
}

sub getCreationDateString {
	my ($self) = @_;
	return $self->{_creationDate}  || '<unknown>';
}

sub getNextPhaseString {
	...
}

sub getActionString {
	...
}

sub getCurrentStepString {
	...
}

sub getComponentNameString {
	...
}


sub existsMandatoryValidationError {
	return $_[0]->{_existsMandatoryValidationError};
}

#
# Only private subs below this line
#

sub _setFilePath {
	my ($self, $filePath) = @_;
	$self->{_filePath} = $filePath;
}

sub _setExistsMandatoryValidationError {
	$_[0]->{_existsMandatoryValidationError} = $_[1];
}

1;
