package LCM::Python::SLDReconfigurationHelper;

use base qw(LCM::Python::HanaPropertiesHelper);
use SDB::Install::SysVars qw($isWin);
use LCM::Installer;
use SDB::Install::System qw(isSidadmin);

use strict;

use constant RECONFIGURATION_FAILED => 'Reconfiguration of SLD failed; check if HDB is up and running';

use constant RECOFNIGURE_SLD_SCRIPT => <<EOF;
import NameServerPy
import ServiceClientPy
def reconfig():
\tNameServerPy.init()
\tns=NameServerPy.TNSClient()
\tmaster=ns.getValue('/globals/active_master')
\trs=ServiceClientPy.RemoteService(master)
\treturn rs.reconfig()
if __name__=="__main__":
\tprint('reconfigure SLD finished with code "{0}"'.format(reconfig()))
EOF

sub reconfigureSLD {
	my ($self, $sid) = @_;
	my $args = [];
	return $self->_executePythonCommand(RECOFNIGURE_SLD_SCRIPT, RECONFIGURATION_FAILED, $args, $self->getSidadmUid($sid), $self->getSidadmGid($sid));
}

sub setLmStructurePath
{
    my ($self, $sid, $sharedLmStructurePath) = @_;
    $self->getMsgLst()->addMessage("Set global property: lmStructurePath...");
    return $self->setGlobalProperty('nameserver.ini', 'sld', 'lmStructurePath', $sharedLmStructurePath, $self->getSidadmUid($sid), $self->getSidadmGid($sid));
}

sub isSldEnabled
{
    my ($self, $sid) = @_;
    $self->getMsgLst()->addMessage("Checking for enabled SLD on SID $sid...");
    my $result = $self->getGlobalProperty('nameserver.ini', 'sld', 'enable', $self->getSidadmUid($sid), $self->getSidadmGid($sid));
    return undef if(!defined $result);
    return $result eq 'yes';
}

sub setEnableSld {
    my($self, $sid, $value) = @_;
    my $rc = $self->setGlobalProperty('nameserver.ini', 'sld', 'enable', $value, $self->getSidadmUid($sid), $self->getSidadmGid($sid));
    return $rc;
}

sub getSidadmUid {
    my($self, $sid) = @_;
    if(!SDB::Install::System::isSidadmin()){
        my ($uid, $gid) = $self->getPermissions($sid);
        return $uid;
    }
    return undef;
}

sub getSidadmGid {
    my($self, $sid) = @_;
    if(!SDB::Install::System::isSidadmin()){
        my ($uid, $gid) = $self->getPermissions($sid);
        return $gid;
    }
    return undef;
}

1;