package LCM::Slpp::ExecutionState;

use strict;
use experimental qw (smartmatch);

use base qw(Exporter);

use constant STATE_INITIAL     	=> "slp.task.state.INITIAL";
use constant STATE_RUNNING     	=> "slp.task.state.RUNNING";
use constant STATE_DIALOG     	=> "slp.task.state.DIALOG";
use constant STATE_FINISHED     => "slp.task.state.FINISHED";
use constant STATE_ERROR     	=> "slp.task.state.ERROR";
use constant STATE_ABORTED     	=> "slp.task.state.ABORTED";

our @EXPORT_OK = qw(STATE_INITIAL STATE_RUNNING STATE_FINISHED STATE_ERROR STATE_DIALOG STATE_ABORTED getApplicableActions);

my $actions = {
		START => {
			id		 => 'START',
			executor => 'start',	# LCM::Slpp::SlppExecutionHandler::start()
			aplicableStates => [
							STATE_INITIAL,
						 ],
			element	 =>  {
							Action => { 
								id			=> 'START',
								action_type	=> 'slp.action.START',
								inDialog	=> 'false',
								displayName	=> 'START'
							 	}
						}
		},
		ABORT => {
			id		 => 'ABORT',
			executor => 'abort',	# LCM::Slpp::SlppExecutionHandler::abort()
			aplicableStates => [
							STATE_ABORTED,
							STATE_INITIAL,
							STATE_RUNNING,
							STATE_DIALOG,
							STATE_ERROR
						 ],
			element	 =>  { 
							Action => { 
								id			=> 'ABORT',
								action_type	=> 'slp.action.ABORT',
								inDialog	=> 'false',
								displayName	=> 'ABORT'
							 	}
						}
		},
		SUBMIT => {
			id		 => 'SUBMIT',
			executor => 'submit',	# LCM::Slpp::SlppExecutionHandler::submit()
			aplicableStates => [
							STATE_DIALOG
						 ],
			element	 =>  { 
							Action => { 
								id			=> 'SUBMIT',
								action_type	=> 'slp.action.SUBMIT',
								inDialog	=> 'false',
								displayName	=> 'SUBMIT'
							 	}
							}
		}
};

sub getApplicableActions {
	my ($state) = @_;
	my $applicableActions = [];
	for my $actionId (%{$actions}){
		my $action = $actions->{$actionId};
		if($state ~~ @{$action->{aplicableStates}}){
			push(@$applicableActions, $action);
		}
	}
	return $applicableActions;
}

1;
