package LCM::Slpp::ParameterAdapter::ScalarParameter;

use strict;
use base qw(LCM::Slpp::ParameterAdapter);

sub getDefaultSlppValue {
	my ($self) = @_;
	return $self->{hdblcmRepresentation}->{default};
}

sub getSlppValue {
	my ($self) = @_;
	return $self->{hdblcmRepresentation}->{value};
}

sub getSlppBatchValue {
	my ($self) = @_;
	return $self->{hdblcmRepresentation}->{batchValue};
}

sub getSlppValueTag {
	return 'value';
}

sub getSlppBatchValueTag {
	return 'batchvalue';
}

sub hasDefault {
	return defined($_[0]->{hdblcmRepresentation}->{default});
}

sub parseInternalValue {
	my ($self, $slppRepresentation, $isBatchValue) = @_;
	return $isBatchValue ? $slppRepresentation->{batchvalue} : $slppRepresentation->{value};
}

1;