package LCM::Slpp::ParameterAdapter::SingleSelectionParameter;

use strict;
use base qw(LCM::Slpp::ParameterAdapter::SelectionParameter);

sub getInternalSelectedValues {
	my ($self) = @_;
	return [$self->{hdblcmRepresentation}->{value}];
}

sub getInternalDefaultValues {
	my ($self) = @_;
	return [$self->{hdblcmRepresentation}->{default}];
}

sub getInternalBatchValues {
	my ($self) = @_;
	return [$self->{hdblcmRepresentation}->{batchValue}];
}

sub parseInternalValue {
	my ($self, $slppRepresentation, $isBatchValue) = @_;
	
	my $paramId = $self->{parameterID};
	my $selectedValues = $self->_parseSelectedValues($slppRepresentation, $isBatchValue);
	
	my $selectedValuesCount = @{$selectedValues};
	if ($selectedValuesCount > 1) {
#		TODO handle this sutuation appropriately
		die "Cannot set more than one selection for parameter: $paramId"; 
	}
	return $selectedValues->[0];
}

sub hasDefaultTable {
	my ($self) = @_;
	return $self->_isSet() ? 0 : 1;
}

1;