package LCM::Slpp::Update::Listeners::SignatureVerificationSLPListener;

use strict;
use warnings;
use parent 'LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationListenerBase';
use SDB::Install::Globals qw($gFailedSignatureVerificationMessage);
use LCM::SAPDSigner;


sub onErrorMessage {
    my ($self, $msg, $configuration) = @_;
    $self->addWarningMessage($msg);
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    $instconfig->clearParameterWarnings('VerifySignature');
    return $self->SUPER::onValueChange($value, $instconfig);
}

sub handleVerificationFailure {
    my ($self, $instconfig) = @_;
    my $sapdsigner = LCM::SAPDSigner->getInstance();

    $instconfig->clearParameterWarnings('VerifySignature');
    $instconfig->addParameterWarning('VerifySignature', $self->getFailedVerificationMessage());
    return 1;
}

1;