package LCM::SummaryTreeBuilders::RemoveHostRolesSummaryTreeBuilder;

use strict;
use LCM::AdditionalHostHelper;
use SDB::Install::Globals qw (getHumanReadableRolesString);

sub buildSummaryTree {
    require LCM::SummaryTreeBuilder;

    my ($instconfig) = @_;

    my $roottext =  $instconfig->getProductName();
    my @rootChildren = ();

    my $summaryTree  = {
        "text"     => $roottext,
        "warnings" => [],
        "children" => \@rootChildren
    };

    push( @rootChildren, _buildOperationParamsNode($instconfig) );
    push( @rootChildren, _buildRemoveRolesNode($instconfig) );

    if ( LCM::SummaryTreeBuilder::_shouldBuildAutoAddedXs2RolesNode($instconfig) ) {
        push( @rootChildren, LCM::SummaryTreeBuilder::_buildAutoAddedXs2RolesNode( $instconfig ));
    }
    push(@rootChildren, LCM::SummaryTreeBuilder::_buildLogLocationInfoNode($instconfig));
    return $summaryTree;
}

sub _buildOperationParamsNode {
    my ($instconfig)           = @_;
    my @operationParams        = ();

    my $operationParamsNodeRef = {
        "text" => "Remove Host Roles Parameters",
        "children" => \@operationParams
    };

    my $param;
    for my $param_id ( @{ $instconfig->getParamIds() } ) {
        $param = $instconfig->{params}->{$param_id};
        if ( $param->{skip} ) {
            next;
        }

        if ( $param->{type} eq 'passwd' || $param->{type} eq 'initial_passwd' ) {
            next;
        }

        if( $param_id =~ /RemoveRoles|Target|SID/) {
            next;
        }

        if (! (defined $param->{hidden} && $param->{hidden}) ) {
            my $text = "$param->{str}: " . $instconfig->getLogValue($param_id);
            my $nodeRef = { "text" => $text };
            push( @operationParams, $nodeRef );
        }
    }
    return $operationParamsNodeRef;
}

sub _buildRemoveRolesNode {
    my ($instconfig) = @_;

    my @hostsChildren = ();
    my $hostsNodeRef  = {
        "text"     => "Remove Host Roles",
        "children" => \@hostsChildren
    };
    my $ownInstance = $instconfig->getOwnInstance();
    my $mHostRolesInfo = $ownInstance->getHostRolesInfo();
    my $mRemoveRolesValue = $instconfig->getValue('RemoveRoles');

    foreach my $host (keys %$mRemoveRolesValue){
        my @hostChildren = ();
        my $originalRoles = join(',', split(' ', $mHostRolesInfo->{$host}));
        my $additionalRoles = $mRemoveRolesValue->{$host};
        next if (! defined $additionalRoles);

        push( @hostChildren, {text => "Removed Role(s): " . $additionalRoles});
        my $hostNode = {
            "text"     => $host,
            "children" => \@hostChildren
        };
        push(@hostsChildren, $hostNode);
    }
    return $hostsNodeRef;
}

1;