package LCM::Task::AddHostRolesProcessTask;
use parent qw (LCM::Task::SLProcessTask);
use strict;

use LCM::Task::CommonTask::AssignAdditionalLocalRolesTask;
use LCM::Task::CommonTask::AssignAdditionalRemoteRolesTask;

my $ACTION_DONE_MESSAGE = "Additional host roles successfully assigned";
my $ACTION_DONE_WITH_WARNINGS_MESSAGE = "Additional host roles assigned with warnings.";
my $ACTION_FAILED_MESSAGE = "Assignment of additional host roles failed.";
my $ACTION_ABORTED_MESSAGE = "Assignment of additional host roles aborted.";


sub new{
    my ($class, $configuration) = @_;
    my $self = $class->SUPER::new($configuration);
    my $status = $self->getStatus();
    $status->_setActionDoneMessage($ACTION_DONE_MESSAGE);
    $status->_setActionDoneWithWarningsMessage($ACTION_DONE_WITH_WARNINGS_MESSAGE);
    $status->_setActionFailedMessage($ACTION_FAILED_MESSAGE);
    $status->_setActionAbortedMessage($ACTION_ABORTED_MESSAGE);
    return $self;
}

sub _createSubtasks {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration(); #AddHostRolesConfiguration
    if ($configuration->isAddingAdditionalLocalRoles()) {
        $self->addSubtask(new LCM::Task::CommonTask::AssignAdditionalLocalRolesTask($configuration));
    }
    if ($configuration->isAddingAdditionalRemoteRoles()) {
        $self->addSubtask(new LCM::Task::CommonTask::AssignAdditionalRemoteRolesTask($configuration));
    }
}

sub _executeInternal {
    my $self = shift();
    $self->_createSubtasks();
    $self->SUPER::_executeInternal(@_);
}

sub getId {
    return "add_host_roles";
}

sub getName {
    return "Add host roles";
}

1;