package LCM::Task::AddHostsProcessTask;

use strict;
use parent qw(LCM::Task::SLProcessTask);
use LCM::Task qw($gFlavourProductName);
use LCM::Task::Hosts::AddHosts::UpdateHostsTaskListFactory;
use LCM::Task::Hosts::AddHosts::AddLocalHostTask;
use LCM::Task::CommonTask::UpdateComponentListTask;
use LCM::Task::Hosts::AddHosts::AddRemoteHostsTask;
use LCM::HostsParser qw(ExtractLocalAndRemoteHosts);
use LCM::HostsUtility qw(IsHostPartOfSystem);

my $ACTION_DONE_MESSAGE = "Additional hosts added to the $gFlavourProductName System";
my $ACTION_FAILED_MESSAGE = "Addition of hosts to the $gFlavourProductName System failed.";
my $ACTION_ABORTED_MESSAGE = "Addition of hosts to the $gFlavourProductName System aborted.";
my $ACTION_DONE_WITH_WARNINGS_MESSAGE = "Additional hosts added to the $gFlavourProductName System with warnings.";

sub new{
    my ($class, $configuration) = @_;
    my $self = $class->SUPER::new($configuration);
    my $status = $self->getStatus();

    $status->_setActionDoneMessage($self->_formatMessage($ACTION_DONE_MESSAGE));
    $status->_setActionDoneWithWarningsMessage($self->_formatMessage($ACTION_DONE_WITH_WARNINGS_MESSAGE));
    $status->_setActionFailedMessage($self->_formatMessage($ACTION_FAILED_MESSAGE));
    $status->_setActionAbortedMessage($self->_formatMessage($ACTION_ABORTED_MESSAGE));

    return $self;
}

# Override
sub getId {
    return "add_hosts";
}

# Override
sub getName {
    return "Add Hosts";
}

# Override
sub _executeInternal {
    my $self = shift();
    $self->_createSubtasks();
    $self->SUPER::_executeInternal(@_);
}

sub _createSubtasks {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $isAddingLocalHost = $self->_isAddingLocalHost();
    my $isAddingRemoteHosts = $self->_isAddingRemoteHost();

    $self->addSubtask(new LCM::Task::Hosts::AddHosts::AddLocalHostTask($configuration)) if($isAddingLocalHost);
    $self->addSubtask(new LCM::Task::Hosts::AddHosts::AddRemoteHostsTask($configuration)) if($isAddingRemoteHosts);
    my $updateHostsFactory = new LCM::Task::Hosts::AddHosts::UpdateHostsTaskListFactory ($configuration);
    $self->addSubtask($updateHostsFactory->createUpdateLocalHostTask()) if ($isAddingLocalHost);
    $self->addSubtask($updateHostsFactory->createUpdateRemoteHostsTask([$configuration->getAdditionalRemoteHosts()])) if($isAddingRemoteHosts);
    $self->addSubtask(new LCM::Task::CommonTask::UpdateComponentListTask($configuration));
}

sub _isAddingLocalHost {
    return IsHostPartOfSystem() ? 0 : 1;
}

sub _isAddingRemoteHost {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $addHostsValue = $configuration->getValue("AddHosts");
    my ($localHostInputString, $remoteHostsInputString) = ExtractLocalAndRemoteHosts($addHostsValue, $self->getMsgLst());

    return defined($remoteHostsInputString) && length($remoteHostsInputString) ? 1 : 0;
}

1;