package LCM::Task::CommonTask::UpdateComponentListOnLocalHostTask;

use strict;
use SDB::Install::SAPSystem;
use LCM::Landscape::LandscapeDescription;
use parent qw(LCM::Task::CommonTask::UpdateComponentListTask);

# Override
sub getId { return 'update_component_list_on_local_host'; }

# Override
sub getName {
    my $self = shift;
    return $self->SUPER::getName(@_) . ' on Local Host';
}

# Override
sub getExecutionName {
    my $self = shift;
    return $self->SUPER::getExecutionName(@_) . ' on Local Host';
}

sub _getLandscapeDescription {
    my ($self, $msgLst) = @_;

    my $configuration = $self->_getConfiguration();
    my $target = $configuration->getValue('Target');
    my $sid = $configuration->getValue('SID');

    my $sapSys = new SDB::Install::SAPSystem();
    $sapSys->initWithGlobDir($sid, $target);

    return new LCM::Landscape::LandscapeDescription([$msgLst], $sid, $sapSys);
}

sub _isUpdatingLMStructure {
    return 1;
}

1;