package LCM::Task::ConfigureSLDProcessTask;

use strict;
use File::Spec;
use parent 'LCM::Task::SLProcessTask';

use LCM::Task::ConfigureSLDTask::ConfigureSLDTask;

my $ACTION_DONE_MESSAGE = 'Registration in System Landscape Directory configured.';
my $ACTION_DONE_WITH_WARNINGS_MESSAGE = 'Registration in System Landscape Directory configured with warnings.';
my $ACTION_FAILED_MESSAGE = 'Registration in System Landscape Directory failed.';
my $ACTION_ABORTED_MESSAGE = 'Registration in System Landscape Directory aborted.';

my $UNABLE_TO_GET_HDB = 'Unable to get HDB Instance';

sub new{
	my ($class, $configuration) = @_;
	my $self = $class->SUPER::new($configuration);
	my $status = $self->getStatus();
	$status->_setActionDoneMessage($ACTION_DONE_MESSAGE);
	$status->_setActionDoneWithWarningsMessage($ACTION_DONE_WITH_WARNINGS_MESSAGE);
	$status->_setActionFailedMessage($ACTION_FAILED_MESSAGE);
	$status->_setActionAbortedMessage($ACTION_ABORTED_MESSAGE);
	$self->addSubtask(new LCM::Task::ConfigureSLDTask::ConfigureSLDTask($configuration));
	return $self;
}

sub getId{
	return 'configure_sld';
}

sub getName {
	return 'Configure System Landscape Directory Registration';
}

1;
